/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.common.config;

import java.util.Collections;
import java.util.List;

public class ServerConnectorConfig {
    public static final Integer DEFAULT_HTTP_PORT = 8080;
    public static final Integer DEFAULT_HTTPS_PORT = 8443;
    private Integer port;
    private String address;
    private Boolean enabled;
    private Boolean http2;
    private Boolean proxyForwarding;
    private Integer requestHeaderSize;
    private Integer responseHeaderSize;
    private Integer idleTimeout;
    private String keystorePath;
    private String keystorePassword;
    private String keyAlias;
    private String keyPassword;
    private List<String> sslProtocols;
    private List<String> sslCiphers;

    private ServerConnectorConfig() {
    }

    public Integer getPort() {
        return this.port;
    }

    public String getAddress() {
        return this.address;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean getHttp2() {
        return this.http2;
    }

    public Boolean getProxyForwarding() {
        return this.proxyForwarding;
    }

    public Integer getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public Integer getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public List<String> getSslProtocols() {
        return this.sslProtocols;
    }

    public List<String> getSslCiphers() {
        return this.sslCiphers;
    }

    public static class Builder {
        private Integer port;
        private String address;
        private Boolean enabled;
        private Boolean http2 = false;
        private Boolean proxyForwarding = false;
        private Integer requestHeaderSize = 8192;
        private Integer responseHeaderSize = 8192;
        private Integer idleTimeout = 30000;
        private String keystorePath;
        private String keystorePassword;
        private String keyAlias;
        private String keyPassword;
        private List<String> sslProtocols;
        private List<String> sslCiphers;

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder http2(Boolean http2) {
            this.http2 = http2;
            return this;
        }

        public Builder proxyForwarding(Boolean proxyForwarding) {
            this.proxyForwarding = proxyForwarding;
            return this;
        }

        public Builder requestHeaderSize(Integer requestHeaderSize) {
            this.requestHeaderSize = requestHeaderSize;
            return this;
        }

        public Builder responseHeaderSize(Integer responseHeaderSize) {
            this.responseHeaderSize = responseHeaderSize;
            return this;
        }

        public Builder idleTimeout(Integer idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public Builder keystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        public Builder keystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public Builder keyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            return this;
        }

        public Builder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder sslProtocols(List<String> sslProtocols) {
            this.sslProtocols = Collections.unmodifiableList(sslProtocols);
            return this;
        }

        public Builder sslCiphers(List<String> sslCiphers) {
            this.sslCiphers = Collections.unmodifiableList(sslCiphers);
            return this;
        }

        public ServerConnectorConfig build() {
            ServerConnectorConfig serverConnectorConfig = new ServerConnectorConfig();
            serverConnectorConfig.port = this.port;
            serverConnectorConfig.address = this.address;
            serverConnectorConfig.enabled = this.enabled;
            serverConnectorConfig.http2 = this.http2;
            serverConnectorConfig.proxyForwarding = this.proxyForwarding;
            serverConnectorConfig.requestHeaderSize = this.requestHeaderSize;
            serverConnectorConfig.responseHeaderSize = this.responseHeaderSize;
            serverConnectorConfig.idleTimeout = this.idleTimeout;
            serverConnectorConfig.keystorePath = this.keystorePath;
            serverConnectorConfig.keystorePassword = this.keystorePassword;
            serverConnectorConfig.keyAlias = this.keyAlias;
            serverConnectorConfig.keyPassword = this.keyPassword;
            serverConnectorConfig.sslProtocols = this.sslProtocols;
            serverConnectorConfig.sslCiphers = this.sslCiphers;
            return serverConnectorConfig;
        }
    }
}

