/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.common.config;

import com.kumuluz.ee.common.config.DataSourcePoolConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class XaDataSourceConfig {
    private String jndiName;
    private String xaDatasourceClass;
    private String username;
    private String password;
    private DataSourcePoolConfig pool;
    private Map<String, String> props;

    private XaDataSourceConfig() {
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getXaDatasourceClass() {
        return this.xaDatasourceClass;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public DataSourcePoolConfig getPool() {
        return this.pool;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public static class Builder {
        private String jndiName;
        private String xaDatasourceClass;
        private String username;
        private String password;
        private DataSourcePoolConfig.Builder pool = new DataSourcePoolConfig.Builder();
        private Map<String, String> props = new HashMap<String, String>();

        public Builder jndiName(String jndiName) {
            this.jndiName = jndiName;
            return this;
        }

        public Builder xaDatasourceClass(String xaDatasourceClass) {
            this.xaDatasourceClass = xaDatasourceClass;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder pool(DataSourcePoolConfig.Builder pool) {
            this.pool = pool;
            return this;
        }

        public Builder prop(String key, String value) {
            this.props.put(key, value);
            return this;
        }

        public XaDataSourceConfig build() {
            XaDataSourceConfig xaDataSourceConfig = new XaDataSourceConfig();
            xaDataSourceConfig.jndiName = this.jndiName;
            xaDataSourceConfig.xaDatasourceClass = this.xaDatasourceClass;
            xaDataSourceConfig.username = this.username;
            xaDataSourceConfig.password = this.password;
            xaDataSourceConfig.pool = this.pool.build();
            xaDataSourceConfig.props = Collections.unmodifiableMap(this.props);
            return xaDataSourceConfig;
        }
    }
}

