/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.common.datasources;

import com.kumuluz.ee.common.config.XaDataSourceConfig;
import com.kumuluz.ee.common.exceptions.KumuluzServerException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.sql.XADataSource;

@Deprecated
public class XADataSourceBuilder {
    private XaDataSourceConfig xaDataSourceConfig;

    public XADataSourceBuilder(XaDataSourceConfig xaDataSourceConfig) {
        this.xaDataSourceConfig = xaDataSourceConfig;
    }

    public XADataSource constructXaDataSource() {
        if (this.xaDataSourceConfig == null) {
            throw new KumuluzServerException("The XADataSource configuration object for creating a XADataSource cannot be null.");
        }
        if (this.xaDataSourceConfig.getXaDatasourceClass() == null) {
            throw new KumuluzServerException("The XADataSource class config property 'xa-datasource-class' for creating a XADataSource must be provided.");
        }
        XADataSource xaDataSource = this.createXaDataSourceObject();
        this.setProperty(xaDataSource, "user", this.xaDataSourceConfig.getUsername());
        this.setProperty(xaDataSource, "password", this.xaDataSourceConfig.getPassword());
        this.xaDataSourceConfig.getProps().forEach((k, v) -> this.setProperty(xaDataSource, (String)k, (String)v));
        return xaDataSource;
    }

    private XADataSource createXaDataSourceObject() {
        try {
            return (XADataSource)Class.forName(this.xaDataSourceConfig.getXaDatasourceClass()).newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            String msg = "The XADataSource class '" + this.xaDataSourceConfig.getXaDatasourceClass() + "' is either incorrect or is not present in the classpath.";
            throw new KumuluzServerException(msg, e);
        }
    }

    private void setProperty(Object object, String name, String value) {
        name = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method[] methods = object.getClass().getMethods();
        Method matchingMethod = null;
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase(name) || method.getParameterTypes().length != 1) continue;
            matchingMethod = method;
            break;
        }
        if (matchingMethod == null) {
            String msg = "The XADataSource configuration property '" + name + "' is either incorrect or doesn't exist.";
            throw new KumuluzServerException(msg);
        }
        Class<?> type = matchingMethod.getParameterTypes()[0];
        Object argument = value;
        if (type == Integer.TYPE) {
            argument = Integer.valueOf(value);
        }
        if (type == Boolean.TYPE) {
            argument = Boolean.valueOf(value);
        }
        try {
            matchingMethod.invoke(object, argument);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            String msg = "The XADataSource configuration property '" + name + "' is either incorrect or doesn't exist.";
            throw new KumuluzServerException(msg, e);
        }
    }
}

