/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.configuration.sources;

import com.kumuluz.ee.configuration.ConfigurationSource;
import com.kumuluz.ee.configuration.utils.ConfigurationDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class EnvironmentConfigurationSource
implements ConfigurationSource {
    @Override
    public void init(ConfigurationDispatcher configurationDispatcher) {
    }

    @Override
    public Optional<String> get(String key) {
        String possibleName;
        String value = null;
        Iterator<String> iterator = this.getPossibleEnvNames(key).iterator();
        while (iterator.hasNext() && (value = System.getenv(possibleName = iterator.next())) == null) {
        }
        return Optional.ofNullable(value);
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        Optional<String> value = this.get(key);
        return value.map(Boolean::valueOf);
    }

    @Override
    public Optional<Integer> getInteger(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Integer.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> getLong(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Long.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Double> getDouble(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Double.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Float> getFloat(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Float.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Integer> getListSize(String key) {
        for (String possibleKeyName : this.getPossibleEnvNames(key)) {
            Integer idx2;
            int closingIndex;
            int openingIndex;
            Integer maxIndex = -1;
            for (String envName : System.getenv().keySet()) {
                if (!envName.startsWith(possibleKeyName)) continue;
                openingIndex = possibleKeyName.length();
                closingIndex = envName.indexOf("_", openingIndex + 1);
                if (closingIndex < 0) {
                    closingIndex = envName.length();
                }
                try {
                    idx2 = Integer.parseInt(envName.substring(openingIndex, closingIndex));
                    maxIndex = Math.max(maxIndex, idx2);
                }
                catch (NumberFormatException idx2) {}
            }
            if (maxIndex != -1) {
                return Optional.of(maxIndex + 1);
            }
            for (String envName : System.getenv().keySet()) {
                if (!envName.startsWith(possibleKeyName)) continue;
                openingIndex = possibleKeyName.length() + 1;
                closingIndex = envName.indexOf("]", openingIndex + 1);
                if (closingIndex < 0) {
                    closingIndex = envName.indexOf("_", openingIndex + 1);
                }
                if (closingIndex < 0) {
                    closingIndex = envName.length() - 1;
                }
                if (openingIndex >= closingIndex) continue;
                try {
                    idx2 = Integer.parseInt(envName.substring(openingIndex, closingIndex));
                    maxIndex = Math.max(maxIndex, idx2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (maxIndex == -1) continue;
            return Optional.of(maxIndex + 1);
        }
        return Optional.empty();
    }

    @Override
    public Optional<List<String>> getMapKeys(String key) {
        HashSet<String> mapKeys = new HashSet<String>();
        HashSet<String> envKeys = new HashSet<String>(System.getenv().keySet());
        List<String> possibleKeyNames = key.equals("") ? Collections.singletonList("") : this.getPossibleEnvNames(key);
        for (String possibleKeyName : possibleKeyNames) {
            HashSet<String> toRemove = new HashSet<String>();
            for (String envKey : envKeys) {
                String mapKey;
                int startIdx;
                int separatorIdx;
                if (!possibleKeyName.equals("") && possibleKeyName.length() + 1 > envKey.length() || !envKey.startsWith(possibleKeyName)) continue;
                if (possibleKeyName.equals("")) {
                    int dotIdx = envKey.indexOf(46);
                    int underscoreIdx = envKey.indexOf(95);
                    separatorIdx = dotIdx > 0 && underscoreIdx > 0 ? Math.min(dotIdx, underscoreIdx) : Math.max(dotIdx, underscoreIdx);
                    startIdx = 0;
                } else {
                    char separator = envKey.charAt(possibleKeyName.length());
                    if (separator != '.' && separator != '_') continue;
                    startIdx = possibleKeyName.length() + 1;
                    separatorIdx = envKey.indexOf(separator, startIdx);
                }
                if (separatorIdx < 0) {
                    separatorIdx = envKey.length();
                }
                if ((mapKey = envKey.substring(startIdx, separatorIdx)).isEmpty()) continue;
                int bracketIndex = mapKey.indexOf("[");
                if (bracketIndex > 0) {
                    mapKey = mapKey.substring(0, bracketIndex);
                }
                mapKeys.add(mapKey.toLowerCase());
                toRemove.add(envKey);
            }
            envKeys.removeAll(toRemove);
        }
        if (mapKeys.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(new ArrayList(mapKeys));
    }

    @Override
    public void watch(String key) {
    }

    @Override
    public void set(String key, String value) {
    }

    @Override
    public void set(String key, Boolean value) {
    }

    @Override
    public void set(String key, Integer value) {
    }

    @Override
    public void set(String key, Double value) {
    }

    @Override
    public void set(String key, Float value) {
    }

    @Override
    public Integer getOrdinal() {
        return this.getInteger("config_ordinal").orElse(300);
    }

    private List<String> getPossibleEnvNames(String key) {
        LinkedList<String> possibleNames = new LinkedList<String>();
        possibleNames.add(key);
        possibleNames.add(this.replaceNonAlphaNum(key));
        possibleNames.add(this.replaceNonAlphaNum(key).toUpperCase());
        possibleNames.add(this.parseKeyNameForEnvironmentVariables(key));
        possibleNames.add(this.parseKeyNameForEnvironmentVariablesLegacy(key));
        return possibleNames;
    }

    private String replaceNonAlphaNum(String s) {
        return s.replaceAll("[^a-zA-Z0-9]", "_");
    }

    private String parseKeyNameForEnvironmentVariables(String key) {
        return key.toUpperCase().replaceAll("\\[", "").replaceAll("]", "").replaceAll("-", "").replaceAll("\\.", "_");
    }

    private String parseKeyNameForEnvironmentVariablesLegacy(String key) {
        return key.toUpperCase().replaceAll("\\.", "_");
    }
}

