/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.configuration.sources;

import com.kumuluz.ee.configuration.ConfigurationSource;
import com.kumuluz.ee.configuration.utils.ConfigurationDispatcher;
import com.kumuluz.ee.configuration.utils.ConfigurationSourceUtils;
import com.kumuluz.ee.logs.LogDeferrer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class FileConfigurationSource
implements ConfigurationSource {
    private Logger log;
    private LogDeferrer<Logger> logDeferrer;
    private String ymlFileName = "config.yml";
    private String yamlFileName = "config.yaml";
    private String propertiesFileName = "config.properties";
    private String microProfilePropertiesFileName = "META-INF/microprofile-config.properties";
    private Map<String, Object> config;
    private Properties properties;

    public FileConfigurationSource() {
        String configurationFileName = System.getProperty("com.kumuluz.ee.configuration.file");
        if (configurationFileName != null && !configurationFileName.isEmpty()) {
            this.ymlFileName = configurationFileName;
            this.yamlFileName = configurationFileName;
            this.propertiesFileName = configurationFileName;
        }
        this.logDeferrer = new LogDeferrer();
        this.logDeferrer.init(() -> Logger.getLogger(FileConfigurationSource.class.getName()));
    }

    public void postInit() {
        this.logDeferrer.execute();
        this.logDeferrer = null;
        this.log = Logger.getLogger(FileConfigurationSource.class.getName());
    }

    @Override
    public void init(ConfigurationDispatcher configurationDispatcher) {
        Yaml yaml = new Yaml();
        try {
            InputStream file = this.getClass().getClassLoader().getResourceAsStream(this.ymlFileName);
            if (file == null) {
                file = this.getClass().getClassLoader().getResourceAsStream(this.yamlFileName);
            }
            if (file == null) {
                try {
                    file = Files.newInputStream(Paths.get(this.ymlFileName, new String[0]), new OpenOption[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (file == null) {
                try {
                    file = Files.newInputStream(Paths.get(this.yamlFileName, new String[0]), new OpenOption[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (file != null) {
                this.logDeferrer.defer(l -> l.info("Loading configuration from YAML file."));
                Object yamlParsed = yaml.load(file);
                if (yamlParsed instanceof Map) {
                    this.config = (Map)yamlParsed;
                } else {
                    this.logDeferrer.defer(l -> l.info("Configuration YAML is malformed as it contains an array at the root level. Skipping."));
                }
                file.close();
            }
        }
        catch (IOException e) {
            this.logDeferrer.defer(l -> l.info("Couldn't successfully process the YAML configuration file.All your properties may not be correctly loaded"));
        }
        if (this.config == null) {
            this.loadProperties(this.propertiesFileName);
            if (this.properties == null) {
                this.loadProperties(this.microProfilePropertiesFileName);
            }
        }
        if (this.config != null || this.properties != null) {
            this.logDeferrer.defer(l -> l.info("Configuration successfully read."));
        } else {
            this.logDeferrer.defer(l -> l.info("Unable to load configuration from file. No configuration files were found."));
        }
    }

    @Override
    public Optional<String> get(String key) {
        String value;
        if (this.config != null) {
            Object value2 = this.getValue(key);
            return value2 == null ? Optional.empty() : Optional.of(value2.toString());
        }
        if (this.properties != null && (value = this.properties.getProperty(key)) != null) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        Optional<String> value = this.get(key);
        return value.map(Boolean::valueOf);
    }

    @Override
    public Optional<Integer> getInteger(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Integer.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> getLong(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Long.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Double> getDouble(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Double.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Float> getFloat(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Float.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Integer> getListSize(String key) {
        if (this.config != null) {
            Object value = this.getValue(key);
            if (value instanceof List) {
                return Optional.of(((List)value).size());
            }
        } else if (this.properties != null) {
            return ConfigurationSourceUtils.getListSize(key, this.properties.stringPropertyNames());
        }
        return Optional.empty();
    }

    @Override
    public Optional<List<String>> getMapKeys(String key) {
        if (this.config != null) {
            Object o = key.equals("") ? this.config : this.getValue(key);
            Map map = null;
            if (o instanceof Map) {
                map = (Map)o;
            }
            if (map == null || map.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new ArrayList(map.keySet()));
        }
        if (this.properties != null) {
            return ConfigurationSourceUtils.getMapKeys(key, this.properties.stringPropertyNames());
        }
        return Optional.empty();
    }

    @Override
    public void watch(String key) {
    }

    @Override
    public void set(String key, String value) {
    }

    @Override
    public void set(String key, Boolean value) {
    }

    @Override
    public void set(String key, Integer value) {
    }

    @Override
    public void set(String key, Double value) {
    }

    @Override
    public void set(String key, Float value) {
    }

    @Override
    public Integer getOrdinal() {
        return this.getInteger("config_ordinal").orElse(100);
    }

    private boolean representsArray(String key) {
        int openingBracket = key.indexOf("[");
        int closingBracket = key.indexOf("]");
        return closingBracket == key.length() - 1 && openingBracket != -1;
    }

    private Object getValue(String key) {
        String[] splittedKeys = key.split("\\.");
        Object value = this.config;
        for (int i = 0; i < splittedKeys.length; ++i) {
            String splittedKey = splittedKeys[i];
            if (value == null) {
                return null;
            }
            if (this.representsArray(splittedKey)) {
                int arrayIndex;
                int openingBracket = splittedKey.indexOf("[");
                int closingBracket = splittedKey.indexOf("]");
                try {
                    arrayIndex = Integer.parseInt(splittedKey.substring(openingBracket + 1, closingBracket));
                }
                catch (NumberFormatException e) {
                    if (this.log != null) {
                        this.log.severe("Cannot cast array index.");
                    }
                    return null;
                }
                splittedKey = splittedKey.substring(0, openingBracket);
                if (!(value instanceof Map)) {
                    return null;
                }
                value = ((Map)value).get(splittedKey);
                if (!(value instanceof List)) continue;
                value = arrayIndex < ((List)value).size() ? ((List)value).get(arrayIndex) : null;
                continue;
            }
            if (value instanceof Map) {
                Object tmpValue = value.get(splittedKey);
                if (tmpValue == null && i != splittedKeys.length - 1) {
                    String postfixKey = Arrays.stream(splittedKeys).skip(i).collect(Collectors.joining("."));
                    return ((Map)value).get(postfixKey);
                }
                value = tmpValue;
                continue;
            }
            return null;
        }
        return value;
    }

    private void loadProperties(String fileName) {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (inputStream == null) {
                try {
                    inputStream = Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                this.logDeferrer.defer(l -> l.info("Loading configuration from .properties file: " + fileName));
                this.properties = new Properties();
                this.properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (IOException e) {
            this.logDeferrer.defer(l -> l.info("Properties file: " + fileName + " not found."));
        }
    }
}

