/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.configuration.utils;

import com.kumuluz.ee.configuration.ConfigurationDecoder;
import com.kumuluz.ee.configuration.ConfigurationSource;
import com.kumuluz.ee.configuration.sources.EnvironmentConfigurationSource;
import com.kumuluz.ee.configuration.sources.FileConfigurationSource;
import com.kumuluz.ee.configuration.sources.SystemPropertyConfigurationSource;
import com.kumuluz.ee.configuration.utils.ConfigurationDispatcher;
import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;

public class ConfigurationImpl {
    private Logger utilLogger;
    private ConfigurationDispatcher dispatcher;
    private List<ConfigurationSource> configurationSources;
    private ConfigurationDecoder configurationDecoder;
    private EnvironmentConfigurationSource environmentConfigurationSource;
    private SystemPropertyConfigurationSource systemPropertyConfigurationSource;
    private FileConfigurationSource fileConfigurationSource;

    public ConfigurationImpl() {
        this.init();
    }

    private void init() {
        this.environmentConfigurationSource = new EnvironmentConfigurationSource();
        this.systemPropertyConfigurationSource = new SystemPropertyConfigurationSource();
        this.fileConfigurationSource = new FileConfigurationSource();
        this.configurationSources = new ArrayList<ConfigurationSource>();
        this.configurationSources.add(this.environmentConfigurationSource);
        this.configurationSources.add(this.systemPropertyConfigurationSource);
        this.configurationSources.add(this.fileConfigurationSource);
        this.dispatcher = new ConfigurationDispatcher();
        for (ConfigurationSource configurationSource : this.configurationSources) {
            configurationSource.init(this.dispatcher);
        }
        ArrayList configurationDecoders = new ArrayList();
        ServiceLoader.load(ConfigurationDecoder.class).forEach(configurationDecoders::add);
        if (configurationDecoders.size() > 1) {
            throw new IllegalStateException("There is more than one service provider defined for the ConfigurationDecoder interface.");
        }
        if (configurationDecoders.size() == 1) {
            this.configurationDecoder = (ConfigurationDecoder)configurationDecoders.get(0);
        }
    }

    public void postInit() {
        this.fileConfigurationSource.postInit();
        this.utilLogger = Logger.getLogger(ConfigurationUtil.class.getName());
    }

    public Boolean isUtilLoggerAvailable() {
        return this.utilLogger != null;
    }

    public Logger getUtilLogger() {
        return this.utilLogger;
    }

    public ConfigurationDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public List<ConfigurationSource> getConfigurationSources() {
        return this.configurationSources;
    }

    public ConfigurationDecoder getConfigurationDecoder() {
        return this.configurationDecoder;
    }
}

