/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.configuration.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class ConfigurationSourceUtils {
    public static Optional<Integer> getListSize(String key, Collection<String> allKeys) {
        Integer maxIndex = -1;
        for (String propertyKey : allKeys) {
            if (!propertyKey.startsWith(key + "[")) continue;
            int openingIndex = key.length() + 1;
            int closingIndex = propertyKey.indexOf("]", openingIndex + 1);
            try {
                Integer idx = Integer.parseInt(propertyKey.substring(openingIndex, closingIndex));
                maxIndex = Math.max(maxIndex, idx);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (maxIndex != -1) {
            return Optional.of(maxIndex + 1);
        }
        return Optional.empty();
    }

    public static Optional<List<String>> getMapKeys(String key, Collection<String> allKeys) {
        HashSet<String> mapKeys = new HashSet<String>();
        for (String propertyKey : allKeys) {
            int bracketIndex;
            int index;
            String mapKey = "";
            if (key.isEmpty()) {
                mapKey = propertyKey;
            } else if (propertyKey.startsWith(key) && (index = key.length() + 1) < propertyKey.length() && propertyKey.charAt(index - 1) == '.') {
                mapKey = propertyKey.substring(index);
            }
            if (mapKey.isEmpty()) continue;
            int endIndex = mapKey.indexOf(".");
            if (endIndex > 0) {
                mapKey = mapKey.substring(0, endIndex);
            }
            if ((bracketIndex = mapKey.indexOf("[")) > 0) {
                mapKey = mapKey.substring(0, bracketIndex);
            }
            mapKeys.add(mapKey);
        }
        if (mapKeys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArrayList(mapKeys));
    }
}

