/*
 *  Copyright (c) 2014-2017 Kumuluz and/or its affiliates
 *  and other contributors as indicated by the @author tags and
 *  the contributor list.
 *
 *  Licensed under the MIT License (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  https://opensource.org/licenses/MIT
 *
 *  The software is provided "AS IS", WITHOUT WARRANTY OF ANY KIND, express or
 *  implied, including but not limited to the warranties of merchantability,
 *  fitness for a particular purpose and noninfringement. in no event shall the
 *  authors or copyright holders be liable for any claim, damages or other
 *  liability, whether in an action of contract, tort or otherwise, arising from,
 *  out of or in connection with the software or the use or other dealings in the
 *  software. See the License for the specific language governing permissions and
 *  limitations under the License.
*/
package com.kumuluz.ee.common.config;

import java.util.List;

/**
 * @author Tilen Faganel
 * @since 2.4.0
 */
public class DevConfig {

    public static class Builder {

        private String webappDir;
        private List<String> scanLibraries;
        private Boolean runningTests = false;

        public Builder scanLibraries(List<String> scanLibraries) {
            this.scanLibraries = scanLibraries;
            return this;
        }

        public Builder webappDir(String webappDir) {
            this.webappDir = webappDir;
            return this;
        }

        public Builder runningTests(Boolean runningTests) {
            this.runningTests = runningTests;
            return this;
        }

        public DevConfig build() {

            DevConfig devConfig = new DevConfig();
            devConfig.webappDir = webappDir;
            devConfig.scanLibraries = scanLibraries;
            devConfig.runningTests = runningTests;

            return devConfig;
        }
    }

    private String webappDir;
    private List<String> scanLibraries;
    private Boolean runningTests;

    private DevConfig() {
    }

    public String getWebappDir() {
        return webappDir;
    }

    public List<String> getScanLibraries() {
        return scanLibraries;
    }

    public Boolean getRunningTests() {
        return runningTests;
    }
}
