/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.common.config;

public class DataSourcePoolConfig {
    private Boolean autoCommit;
    private Boolean flushOnClose;
    private Long connectionTimeout;
    private Long idleTimeout;
    private Long maxLifetime;
    @Deprecated
    private Integer minIdle;
    private Integer initialSize = 0;
    private Integer minSize = 0;
    private Integer maxSize;
    @Deprecated
    private String name;
    @Deprecated
    private Long initializationFailTimeout;
    @Deprecated
    private Boolean isolateInternalQueries;
    @Deprecated
    private Boolean allowPoolSuspension;
    @Deprecated
    private Boolean readOnly;
    @Deprecated
    private Boolean registerMbeans;
    private String connectionInitSql;
    private String connectionValidSql;
    private String transactionIsolation;
    private Long validationTimeout;
    private Long leakDetectionThreshold;
    private Long idleValidationTimeout;

    private DataSourcePoolConfig() {
    }

    public Boolean getFlushOnClose() {
        return this.flushOnClose;
    }

    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public Long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Deprecated
    public Integer getMinIdle() {
        return this.minIdle;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    @Deprecated
    public Long getInitializationFailTimeout() {
        return this.initializationFailTimeout;
    }

    @Deprecated
    public Boolean getIsolateInternalQueries() {
        return this.isolateInternalQueries;
    }

    @Deprecated
    public Boolean getAllowPoolSuspension() {
        return this.allowPoolSuspension;
    }

    @Deprecated
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Deprecated
    public Boolean getRegisterMbeans() {
        return this.registerMbeans;
    }

    public String getConnectionInitSql() {
        return this.connectionInitSql;
    }

    public String getConnectionValidSql() {
        return this.connectionValidSql;
    }

    public String getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public Long getValidationTimeout() {
        return this.validationTimeout;
    }

    public Long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    public Long getIdleValidationTimeout() {
        return this.idleValidationTimeout;
    }

    public static class Builder {
        private Boolean autoCommit = true;
        private Boolean flushOnClose = false;
        private Long connectionTimeout = 30000L;
        private Long idleTimeout = 600000L;
        private Long maxLifetime = 1800000L;
        @Deprecated
        private Integer minIdle;
        private Integer initialSize = 0;
        private Integer minSize = 0;
        private Integer maxSize = 10;
        @Deprecated
        private String name;
        @Deprecated
        private Long initializationFailTimeout;
        @Deprecated
        private Boolean isolateInternalQueries;
        @Deprecated
        private Boolean allowPoolSuspension;
        @Deprecated
        private Boolean readOnly;
        @Deprecated
        private Boolean registerMbeans;
        private String connectionInitSql;
        private String connectionValidSql;
        private String transactionIsolation;
        private Long validationTimeout = 5000L;
        private Long leakDetectionThreshold = 0L;
        private Long idleValidationTimeout = 0L;

        public Builder autoCommit(Boolean autoCommit) {
            this.autoCommit = autoCommit;
            return this;
        }

        public Builder flushOnClose(Boolean flushOnClose) {
            this.flushOnClose = flushOnClose;
            return this;
        }

        public Builder connectionTimeout(Long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder idleTimeout(Long idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public Builder maxLifetime(Long maxLifetime) {
            this.maxLifetime = maxLifetime;
            return this;
        }

        @Deprecated
        public Builder minIdle(Integer minIdle) {
            this.minIdle = minIdle;
            return this;
        }

        public Builder initialSize(Integer initialSize) {
            this.initialSize = initialSize;
            return this;
        }

        public Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        @Deprecated
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Deprecated
        public Builder initializationFailTimeout(Long initializationFailTimeout) {
            this.initializationFailTimeout = initializationFailTimeout;
            return this;
        }

        @Deprecated
        public Builder isolateInternalQueries(Boolean isolateInternalQueries) {
            this.isolateInternalQueries = isolateInternalQueries;
            return this;
        }

        @Deprecated
        public Builder allowPoolSuspension(Boolean allowPoolSuspension) {
            this.allowPoolSuspension = allowPoolSuspension;
            return this;
        }

        @Deprecated
        public Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Deprecated
        public Builder registerMbeans(Boolean registerMbeans) {
            this.registerMbeans = registerMbeans;
            return this;
        }

        public Builder connectionInitSql(String connectionInitSql) {
            this.connectionInitSql = connectionInitSql;
            return this;
        }

        public Builder connectionValidSql(String connectionValidSql) {
            this.connectionValidSql = connectionValidSql;
            return this;
        }

        public Builder transactionIsolation(String transactionIsolation) {
            this.transactionIsolation = transactionIsolation;
            return this;
        }

        public Builder validationTimeout(Long validationTimeout) {
            this.validationTimeout = validationTimeout;
            return this;
        }

        public Builder leakDetectionThreshold(Long leakDetectionThreshold) {
            this.leakDetectionThreshold = leakDetectionThreshold;
            return this;
        }

        public Builder idleValidationTimeout(Long idleValidationTimeout) {
            this.idleValidationTimeout = idleValidationTimeout;
            return this;
        }

        public DataSourcePoolConfig build() {
            DataSourcePoolConfig dataSourcePoolConfig = new DataSourcePoolConfig();
            dataSourcePoolConfig.autoCommit = this.autoCommit;
            dataSourcePoolConfig.flushOnClose = this.flushOnClose;
            dataSourcePoolConfig.connectionTimeout = this.connectionTimeout;
            dataSourcePoolConfig.idleTimeout = this.idleTimeout;
            dataSourcePoolConfig.maxLifetime = this.maxLifetime;
            dataSourcePoolConfig.minIdle = this.minIdle;
            dataSourcePoolConfig.initialSize = this.initialSize;
            dataSourcePoolConfig.minSize = this.minSize;
            dataSourcePoolConfig.maxSize = this.maxSize;
            dataSourcePoolConfig.name = this.name;
            dataSourcePoolConfig.initializationFailTimeout = this.initializationFailTimeout;
            dataSourcePoolConfig.isolateInternalQueries = this.isolateInternalQueries;
            dataSourcePoolConfig.allowPoolSuspension = this.allowPoolSuspension;
            dataSourcePoolConfig.readOnly = this.readOnly;
            dataSourcePoolConfig.registerMbeans = this.registerMbeans;
            dataSourcePoolConfig.connectionInitSql = this.connectionInitSql;
            dataSourcePoolConfig.connectionValidSql = this.connectionValidSql;
            dataSourcePoolConfig.transactionIsolation = this.transactionIsolation;
            dataSourcePoolConfig.validationTimeout = this.validationTimeout;
            dataSourcePoolConfig.leakDetectionThreshold = this.leakDetectionThreshold;
            dataSourcePoolConfig.idleValidationTimeout = this.idleValidationTimeout;
            return dataSourcePoolConfig;
        }
    }
}

