/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.common.config;

public class MailServiceConfig {
    private String protocol;
    private String host;
    private Integer port;
    private Boolean starttls;
    private String username;
    private String password;
    private Long connectionTimeout;
    private Long timeout;

    private MailServiceConfig() {
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Boolean getStarttls() {
        return this.starttls;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public static class Builder {
        private String protocol;
        private String host;
        private Integer port;
        private Boolean starttls;
        private String username;
        private String password;
        private Long connectionTimeout;
        private Long timeout;

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder starttls(Boolean starttls) {
            this.starttls = starttls;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder connectionTimeout(Long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public MailServiceConfig build() {
            MailServiceConfig mailServiceConfig = new MailServiceConfig();
            mailServiceConfig.protocol = this.protocol;
            mailServiceConfig.host = this.host;
            mailServiceConfig.port = this.port;
            mailServiceConfig.starttls = this.starttls;
            mailServiceConfig.username = this.username;
            mailServiceConfig.password = this.password;
            mailServiceConfig.connectionTimeout = this.connectionTimeout;
            mailServiceConfig.timeout = this.timeout;
            return mailServiceConfig;
        }
    }
}

