/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.common.config;

import com.kumuluz.ee.common.config.MailServiceConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MailSessionConfig {
    private String jndiName;
    private Boolean debug;
    private MailServiceConfig transport;
    private MailServiceConfig store;
    private Map<String, String> props;

    private MailSessionConfig() {
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public MailServiceConfig getTransport() {
        return this.transport;
    }

    public MailServiceConfig getStore() {
        return this.store;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public static class Builder {
        private String jndiName;
        private Boolean debug;
        private MailServiceConfig.Builder transport;
        private MailServiceConfig.Builder store;
        private Map<String, String> props = new HashMap<String, String>();

        public Builder jndiName(String jndiName) {
            this.jndiName = jndiName;
            return this;
        }

        public Builder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder transport(MailServiceConfig.Builder transport) {
            this.transport = transport;
            return this;
        }

        public Builder store(MailServiceConfig.Builder store) {
            this.store = store;
            return this;
        }

        public Builder prop(String key, String value) {
            this.props.put(key, value);
            return this;
        }

        public MailSessionConfig build() {
            MailSessionConfig mailSessionConfig = new MailSessionConfig();
            mailSessionConfig.jndiName = this.jndiName;
            mailSessionConfig.debug = this.debug;
            if (this.transport != null) {
                mailSessionConfig.transport = this.transport.build();
            }
            if (this.store != null) {
                mailSessionConfig.store = this.store.build();
            }
            mailSessionConfig.props = Collections.unmodifiableMap(this.props);
            return mailSessionConfig;
        }
    }
}

