/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.common.utils;

import com.kumuluz.ee.common.config.DevConfig;
import com.kumuluz.ee.common.config.EeConfig;
import com.kumuluz.ee.common.exceptions.KumuluzServerException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ResourceUtils {
    public static String getProjectWebResources() {
        URL webApp = ResourceUtils.class.getClassLoader().getResource("webapp");
        if (webApp != null) {
            return webApp.toString();
        }
        URL resourceRoot = ResourceUtils.class.getClassLoader().getResource(".");
        if (resourceRoot != null) {
            try {
                Path resourceRootPath = Paths.get(resourceRoot.toURI());
                if (Files.isDirectory(resourceRootPath, new LinkOption[0]) && resourceRootPath.getFileName().toString().equals("classes") && resourceRootPath.getParent() != null && resourceRootPath.getParent().getFileName().toString().equals("target")) {
                    DevConfig devConfig = EeConfig.getInstance().getDev();
                    Path sibling = devConfig.getWebappDir() == null ? Paths.get("src", "main", "webapp") : Paths.get(devConfig.getWebappDir(), new String[0]);
                    Path sourceWebApp = resourceRootPath.getParent().resolveSibling(sibling);
                    if (Files.isDirectory(sourceWebApp, new LinkOption[0])) {
                        return sourceWebApp.toString();
                    }
                }
            }
            catch (URISyntaxException e) {
                throw new KumuluzServerException("Could not retrieve the class loaders' resource dir.", e);
            }
        }
        try {
            Path tempWebApp = Files.createTempDirectory("kumuluzee-tmp-webapp", new FileAttribute[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    Files.delete(tempWebApp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }));
            return tempWebApp.toString();
        }
        catch (IOException e) {
            throw new KumuluzServerException("Could not initialize a temporary webapp directory.", e);
        }
    }

    public static boolean isRunningInJar() {
        URL jar = ResourceUtils.class.getClassLoader().getResource("webapp");
        return (jar == null || jar.toString().toLowerCase().startsWith("jar:")) && ResourceUtils.class.getClassLoader().getClass().getName().equals("com.kumuluz.ee.loader.EeClassLoader");
    }

    public static boolean isRunningTests() {
        return EeConfig.getInstance().getDev().getRunningTests();
    }
}

