/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.configuration.sources;

import com.kumuluz.ee.configuration.ConfigurationSource;
import com.kumuluz.ee.configuration.utils.ConfigurationDispatcher;
import com.kumuluz.ee.configuration.utils.ConfigurationSourceUtils;
import java.util.List;
import java.util.Optional;

public class SystemPropertyConfigurationSource
implements ConfigurationSource {
    @Override
    public void init(ConfigurationDispatcher configurationDispatcher) {
    }

    @Override
    public Optional<String> get(String key) {
        return Optional.ofNullable(System.getProperty(key));
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        Optional<String> value = this.get(key);
        return value.map(Boolean::valueOf);
    }

    @Override
    public Optional<Integer> getInteger(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Integer.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> getLong(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Long.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Double> getDouble(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Double.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Float> getFloat(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Float.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Integer> getListSize(String key) {
        return ConfigurationSourceUtils.getListSize(key, System.getProperties().stringPropertyNames());
    }

    @Override
    public Optional<List<String>> getMapKeys(String key) {
        return ConfigurationSourceUtils.getMapKeys(key, System.getProperties().stringPropertyNames());
    }

    @Override
    public void watch(String key) {
    }

    @Override
    public void set(String key, String value) {
    }

    @Override
    public void set(String key, Boolean value) {
    }

    @Override
    public void set(String key, Integer value) {
    }

    @Override
    public void set(String key, Double value) {
    }

    @Override
    public void set(String key, Float value) {
    }

    @Override
    public Integer getOrdinal() {
        return this.getInteger("config_ordinal").orElse(400);
    }
}

