/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.configuration.utils;

import com.kumuluz.ee.configuration.ConfigurationDecoder;
import com.kumuluz.ee.configuration.ConfigurationListener;
import com.kumuluz.ee.configuration.ConfigurationSource;
import com.kumuluz.ee.configuration.enums.ConfigurationValueType;
import com.kumuluz.ee.configuration.utils.ConfigurationDecoderUtils;
import com.kumuluz.ee.configuration.utils.ConfigurationImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ConfigurationUtil {
    private static ConfigurationUtil instance;
    private ConfigurationImpl config;

    protected ConfigurationUtil() {
    }

    private ConfigurationUtil(ConfigurationImpl config) {
        this.config = config;
    }

    public static void initialize(ConfigurationImpl config) {
        if (instance != null) {
            throw new IllegalStateException("The ConfigurationUtil was already initialized.");
        }
        instance = new ConfigurationUtil(config);
    }

    public static ConfigurationUtil getInstance() {
        if (instance == null) {
            throw new IllegalStateException("The ConfigurationUtil was not yet initialized.");
        }
        return instance;
    }

    public Optional<String> get(String key) {
        return this.get(key, new HashSet<String>());
    }

    public Optional<Boolean> getBoolean(String key) {
        for (ConfigurationSource configurationSource : this.config.getConfigurationSources()) {
            Optional<Boolean> value = configurationSource.getBoolean(key);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    public Optional<Integer> getInteger(String key) {
        for (ConfigurationSource configurationSource : this.config.getConfigurationSources()) {
            Optional<Integer> value = configurationSource.getInteger(key);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    public Optional<Long> getLong(String key) {
        for (ConfigurationSource configurationSource : this.config.getConfigurationSources()) {
            Optional<Long> value = configurationSource.getLong(key);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    public Optional<Double> getDouble(String key) {
        for (ConfigurationSource configurationSource : this.config.getConfigurationSources()) {
            Optional<Double> value = configurationSource.getDouble(key);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    public Optional<Float> getFloat(String key) {
        for (ConfigurationSource configurationSource : this.config.getConfigurationSources()) {
            Optional<Float> value = configurationSource.getFloat(key);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    public Optional<Integer> getListSize(String key) {
        int listSize = -1;
        for (ConfigurationSource configurationSource : this.config.getConfigurationSources()) {
            Optional<Integer> currentListSize = configurationSource.getListSize(key);
            if (!currentListSize.isPresent() || currentListSize.get() <= listSize) continue;
            listSize = currentListSize.get();
        }
        if (listSize == -1) {
            return Optional.empty();
        }
        return Optional.of(listSize);
    }

    public Optional<List<String>> getList(String key) {
        Optional<Integer> listSize = this.getListSize(key);
        if (!listSize.isPresent()) {
            return Optional.empty();
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i < listSize.get(); ++i) {
            Optional<String> value = this.get(key + "[" + i + "]");
            value.ifPresent(list::add);
        }
        return Optional.of(list);
    }

    public void set(String key, String value) {
        this.config.getConfigurationSources().get(0).set(key, value);
    }

    public void set(String key, Boolean value) {
        this.config.getConfigurationSources().get(0).set(key, value);
    }

    public void set(String key, Integer value) {
        this.config.getConfigurationSources().get(0).set(key, value);
    }

    public void set(String key, Double value) {
        this.config.getConfigurationSources().get(0).set(key, value);
    }

    public void set(String key, Float value) {
        this.config.getConfigurationSources().get(0).set(key, value);
    }

    public Optional<ConfigurationValueType> getType(String key) {
        if (this.getListSize(key).isPresent()) {
            return Optional.of(ConfigurationValueType.LIST);
        }
        if (this.getMapKeys(key).isPresent()) {
            return Optional.of(ConfigurationValueType.MAP);
        }
        Optional<String> value = this.get(key);
        if (!value.isPresent()) {
            return Optional.empty();
        }
        if ("true".equals(value.get().toLowerCase()) || "false".equals(value.get().toLowerCase())) {
            return Optional.of(ConfigurationValueType.BOOLEAN);
        }
        try {
            Integer.valueOf(value.get());
            return Optional.of(ConfigurationValueType.INTEGER);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Long.valueOf(value.get());
                return Optional.of(ConfigurationValueType.LONG);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    Float f = Float.valueOf(value.get());
                    if (!f.isInfinite()) {
                        return Optional.of(ConfigurationValueType.FLOAT);
                    }
                }
                catch (NumberFormatException numberFormatException3) {
                    // empty catch block
                }
                try {
                    Double.valueOf(value.get());
                    return Optional.of(ConfigurationValueType.DOUBLE);
                }
                catch (NumberFormatException numberFormatException4) {
                    return Optional.of(ConfigurationValueType.STRING);
                }
            }
        }
    }

    public Optional<List<String>> getMapKeys(String key) {
        HashSet<String> mapKeys = new HashSet<String>();
        for (ConfigurationSource configurationSource : this.config.getConfigurationSources()) {
            Optional<List<String>> value = configurationSource.getMapKeys(key);
            if (!value.isPresent()) continue;
            for (String s : value.get()) {
                if (mapKeys.contains(s.replace("-", ""))) continue;
                mapKeys.add(s);
            }
        }
        if (mapKeys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArrayList(mapKeys));
    }

    public void subscribe(String key, ConfigurationListener listener) {
        this.config.getDispatcher().subscribe(listener);
        for (ConfigurationSource configurationSource : this.config.getConfigurationSources()) {
            configurationSource.watch(key);
        }
    }

    public void unsubscribe(ConfigurationListener listener) {
        this.config.getDispatcher().unsubscribe(listener);
    }

    public List<ConfigurationSource> getConfigurationSources() {
        return Collections.unmodifiableList(this.config.getConfigurationSources());
    }

    public ConfigurationDecoder getConfigurationDecoder() {
        return this.config.getConfigurationDecoder();
    }

    private Optional<String> get(String key, Set<String> processingKeys) {
        for (ConfigurationSource configurationSource : this.config.getConfigurationSources()) {
            Optional<String> value = configurationSource.get(key);
            if (!value.isPresent()) continue;
            return Optional.of(this.interpolateString(key, ConfigurationDecoderUtils.decodeConfigValueIfEncoded(key, value.get()), processingKeys));
        }
        return Optional.empty();
    }

    private String interpolateString(String key, String s, Set<String> processingKeys) {
        int startIndex;
        if (processingKeys.contains(key)) {
            if (this.config.isUtilLoggerAvailable().booleanValue()) {
                this.config.getUtilLogger().warning("Detected cycle when interpolating configuration key: " + key);
            }
            return "";
        }
        processingKeys.add(key);
        while ((startIndex = s.indexOf("${")) >= 0) {
            int endIndex = s.indexOf("}", startIndex + 2);
            String newKey = s.substring(startIndex + 2, endIndex);
            String replacement = this.get(newKey, processingKeys).orElse("");
            processingKeys.remove(newKey);
            s = s.substring(0, startIndex) + replacement + s.substring(endIndex + 1);
        }
        return s;
    }
}

