/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.jsonp.configuration.utils;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class JsonConfigurationUtil {
    private static JsonConfigurationUtil instance = null;
    private ConfigurationUtil config = ConfigurationUtil.getInstance();
    private String mapToNull;
    private String mapToEmptyObject;
    private String mapToEmptyArray;

    private static synchronized void initialize() {
        if (instance == null) {
            instance = JsonConfigurationUtil.getBuilder().build();
        }
    }

    public static JsonConfigurationUtil getInstance() {
        if (instance == null) {
            JsonConfigurationUtil.initialize();
        }
        return instance;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    private JsonConfigurationUtil() {
    }

    private JsonValue getMappingIfAvailable(String s) {
        if (this.mapToNull != null && this.mapToNull.equals(s)) {
            return JsonValue.NULL;
        }
        if (this.mapToEmptyObject != null && this.mapToEmptyObject.equals(s)) {
            return JsonValue.EMPTY_JSON_OBJECT;
        }
        if (this.mapToEmptyArray != null && this.mapToEmptyArray.equals(s)) {
            return JsonValue.EMPTY_JSON_ARRAY;
        }
        return null;
    }

    public Optional<JsonObject> getJsonObject(String key) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        this.config.getMapKeys(key).ifPresent(mapList -> mapList.forEach(prop -> {
            String nextKey = key.equals("") ? prop : key + "." + prop;
            this.config.getType(nextKey).ifPresent(type -> {
                switch (type) {
                    case MAP: {
                        this.getJsonObject(nextKey).ifPresent(o -> objectBuilder.add(prop, (JsonValue)o));
                        break;
                    }
                    case LIST: {
                        this.getJsonArray(nextKey).ifPresent(a -> objectBuilder.add(prop, (JsonValue)a));
                        break;
                    }
                    case INTEGER: {
                        this.config.getInteger(nextKey).ifPresent(value -> objectBuilder.add(prop, value.intValue()));
                        break;
                    }
                    case LONG: {
                        this.config.getLong(nextKey).ifPresent(value -> objectBuilder.add(prop, value.longValue()));
                        break;
                    }
                    case DOUBLE: {
                        this.config.getDouble(nextKey).ifPresent(value -> objectBuilder.add(prop, value.doubleValue()));
                        break;
                    }
                    case FLOAT: {
                        this.config.getFloat(nextKey).ifPresent(value -> objectBuilder.add(prop, (double)value.floatValue()));
                        break;
                    }
                    case BOOLEAN: {
                        this.config.getBoolean(nextKey).ifPresent(value -> objectBuilder.add(prop, value.booleanValue()));
                        break;
                    }
                    case STRING: {
                        this.config.get(nextKey).ifPresent(s -> {
                            JsonValue mapped = this.getMappingIfAvailable((String)s);
                            if (mapped != null) {
                                objectBuilder.add(prop, mapped);
                            } else {
                                objectBuilder.add(prop, s);
                            }
                        });
                    }
                }
            });
        }));
        JsonObject jsonObject = objectBuilder.build();
        if (jsonObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(jsonObject);
    }

    public Optional<JsonArray> getJsonArray(String key) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        this.config.getListSize(key).ifPresent(listSize -> {
            for (int i = 0; i < listSize; ++i) {
                String nextKey = key + "[" + i + "]";
                this.config.getType(nextKey).ifPresent(type -> {
                    switch (type) {
                        case MAP: {
                            this.getJsonObject(nextKey).ifPresent(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
                            break;
                        }
                        case LIST: {
                            this.getJsonArray(nextKey).ifPresent(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
                            break;
                        }
                        case INTEGER: {
                            this.config.getInteger(nextKey).ifPresent(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
                            break;
                        }
                        case LONG: {
                            this.config.getLong(nextKey).ifPresent(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
                            break;
                        }
                        case DOUBLE: {
                            this.config.getDouble(nextKey).ifPresent(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
                            break;
                        }
                        case FLOAT: {
                            this.config.getFloat(nextKey).ifPresent(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
                            break;
                        }
                        case BOOLEAN: {
                            this.config.getBoolean(nextKey).ifPresent(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
                            break;
                        }
                        case STRING: {
                            this.config.get(nextKey).ifPresent(s -> {
                                JsonValue mapped = this.getMappingIfAvailable((String)s);
                                if (mapped != null) {
                                    arrayBuilder.add(mapped);
                                } else {
                                    arrayBuilder.add(s);
                                }
                            });
                        }
                    }
                });
            }
        });
        JsonArray jsonArray = arrayBuilder.build();
        if (jsonArray.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(jsonArray);
    }

    public static final class Builder {
        private String mapToNull;
        private String mapToEmptyObject;
        private String mapToEmptyArray;

        private Builder() {
        }

        public Builder mapToNull(String mapToNull) {
            this.mapToNull = mapToNull;
            return this;
        }

        public Builder mapToEmptyObject(String mapToEmptyObject) {
            this.mapToEmptyObject = mapToEmptyObject;
            return this;
        }

        public Builder mapToEmptyArray(String mapToEmptyArray) {
            this.mapToEmptyArray = mapToEmptyArray;
            return this;
        }

        public JsonConfigurationUtil build() {
            JsonConfigurationUtil jsonConfigurationUtil = new JsonConfigurationUtil();
            jsonConfigurationUtil.mapToEmptyObject = this.mapToEmptyObject;
            jsonConfigurationUtil.mapToEmptyArray = this.mapToEmptyArray;
            jsonConfigurationUtil.mapToNull = this.mapToNull;
            return jsonConfigurationUtil;
        }
    }
}

