/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.architecture.ui.page;

import android.app.Activity;
import android.os.Bundle;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.LifecycleOwner;
import com.kunminx.architecture.ui.page.DataBindingConfig;
import com.kunminx.strictdatabinding.R;

public abstract class DataBindingActivity
extends AppCompatActivity {
    private ViewDataBinding mBinding;
    private TextView mTvStrictModeTip;

    protected abstract void initViewModel();

    protected abstract DataBindingConfig getDataBindingConfig();

    protected ViewDataBinding getBinding() {
        if (this.isDebug() && this.mBinding != null && this.mTvStrictModeTip == null) {
            this.mTvStrictModeTip = new TextView(this.getApplicationContext());
            this.mTvStrictModeTip.setAlpha(0.4f);
            this.mTvStrictModeTip.setTextSize(14.0f);
            this.mTvStrictModeTip.setBackgroundColor(-1);
            this.mTvStrictModeTip.setText(R.string.debug_activity_databinding_warning);
            ((ViewGroup)this.mBinding.getRoot()).addView((View)this.mTvStrictModeTip);
        }
        return this.mBinding;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initViewModel();
        DataBindingConfig dataBindingConfig = this.getDataBindingConfig();
        ViewDataBinding binding = DataBindingUtil.setContentView((Activity)this, (int)dataBindingConfig.getLayout());
        binding.setLifecycleOwner((LifecycleOwner)this);
        binding.setVariable(dataBindingConfig.getVmVariableId(), (Object)dataBindingConfig.getStateViewModel());
        SparseArray bindingParams = dataBindingConfig.getBindingParams();
        int length = bindingParams.size();
        for (int i = 0; i < length; ++i) {
            binding.setVariable(bindingParams.keyAt(i), bindingParams.valueAt(i));
        }
        this.mBinding = binding;
    }

    public boolean isDebug() {
        return this.getApplicationContext().getApplicationInfo() != null && (this.getApplicationContext().getApplicationInfo().flags & 2) != 0;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mBinding.unbind();
        this.mBinding = null;
    }
}

