/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.linkage;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.Guideline;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.kunminx.linkage.R;
import com.kunminx.linkage.adapter.LinkagePrimaryAdapter;
import com.kunminx.linkage.adapter.LinkageSecondaryAdapter;
import com.kunminx.linkage.adapter.viewholder.LinkagePrimaryViewHolder;
import com.kunminx.linkage.bean.BaseGroupedItem;
import com.kunminx.linkage.bean.DefaultGroupedItem;
import com.kunminx.linkage.contract.ILinkagePrimaryAdapterConfig;
import com.kunminx.linkage.contract.ILinkageSecondaryAdapterConfig;
import com.kunminx.linkage.defaults.DefaultLinkagePrimaryAdapterConfig;
import com.kunminx.linkage.defaults.DefaultLinkageSecondaryAdapterConfig;
import com.kunminx.linkage.manager.RecyclerViewScrollHelper;
import java.util.ArrayList;
import java.util.List;

public class LinkageRecyclerView<T extends BaseGroupedItem.ItemInfo>
extends RelativeLayout {
    private static final int DEFAULT_SPAN_COUNT = 1;
    private static final int SCROLL_OFFSET = 0;
    private Context mContext;
    private RecyclerView mRvPrimary;
    private RecyclerView mRvSecondary;
    private ConstraintLayout mLinkageLayout;
    private LinkagePrimaryAdapter mPrimaryAdapter;
    private LinkageSecondaryAdapter mSecondaryAdapter;
    private TextView mTvHeader;
    private FrameLayout mHeaderContainer;
    private List<String> mInitGroupNames;
    private List<BaseGroupedItem<T>> mInitItems;
    private List<Integer> mHeaderPositions = new ArrayList<Integer>();
    private int mTitleHeight;
    private int mFirstVisiblePosition;
    private String mLastGroupName;
    private LinearLayoutManager mSecondaryLayoutManager;
    private LinearLayoutManager mPrimaryLayoutManager;
    private View view;
    private boolean mScrollSmoothly = true;
    private boolean mPrimaryClicked = false;

    public LinkageRecyclerView(Context context) {
        super(context);
    }

    public LinkageRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public LinkageRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private void initView(Context context, @Nullable AttributeSet attrs) {
        this.mContext = context;
        this.view = LayoutInflater.from((Context)context).inflate(R.layout.layout_linkage_view, (ViewGroup)this);
        this.mRvPrimary = (RecyclerView)this.view.findViewById(R.id.rv_primary);
        this.mRvSecondary = (RecyclerView)this.view.findViewById(R.id.rv_secondary);
        this.mHeaderContainer = (FrameLayout)this.view.findViewById(R.id.header_container);
        this.mLinkageLayout = (ConstraintLayout)this.view.findViewById(R.id.linkage_layout);
    }

    private void setLevel2LayoutManager() {
        if (this.mSecondaryAdapter.isGridMode()) {
            this.mSecondaryLayoutManager = new GridLayoutManager(this.mContext, this.mSecondaryAdapter.getConfig().getSpanCountOfGridMode());
            ((GridLayoutManager)this.mSecondaryLayoutManager).setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (((LinkageRecyclerView)LinkageRecyclerView.this).mSecondaryAdapter.getItems().get((int)position).isHeader) {
                        return LinkageRecyclerView.this.mSecondaryAdapter.getConfig().getSpanCountOfGridMode();
                    }
                    return 1;
                }
            });
        } else {
            this.mSecondaryLayoutManager = new LinearLayoutManager(this.mContext, 1, false);
        }
        this.mRvSecondary.setLayoutManager((RecyclerView.LayoutManager)this.mSecondaryLayoutManager);
    }

    private void initRecyclerView(ILinkagePrimaryAdapterConfig primaryAdapterConfig, ILinkageSecondaryAdapterConfig secondaryAdapterConfig) {
        this.mPrimaryAdapter = new LinkagePrimaryAdapter(this.mInitGroupNames, primaryAdapterConfig, new LinkagePrimaryAdapter.OnLinkageListener(){

            @Override
            public void onLinkageClick(LinkagePrimaryViewHolder holder, String title) {
                if (LinkageRecyclerView.this.isScrollSmoothly()) {
                    RecyclerViewScrollHelper.smoothScrollToPosition(LinkageRecyclerView.this.mRvSecondary, -1, (Integer)LinkageRecyclerView.this.mHeaderPositions.get(holder.getBindingAdapterPosition()));
                } else {
                    LinkageRecyclerView.this.mSecondaryLayoutManager.scrollToPositionWithOffset(((Integer)LinkageRecyclerView.this.mHeaderPositions.get(holder.getBindingAdapterPosition())).intValue(), 0);
                }
                LinkageRecyclerView.this.mPrimaryAdapter.setSelectedPosition(holder.getBindingAdapterPosition());
                LinkageRecyclerView.this.mPrimaryClicked = true;
            }
        });
        this.mPrimaryLayoutManager = new LinearLayoutManager(this.mContext);
        this.mRvPrimary.setLayoutManager((RecyclerView.LayoutManager)this.mPrimaryLayoutManager);
        this.mRvPrimary.setAdapter((RecyclerView.Adapter)this.mPrimaryAdapter);
        this.mSecondaryAdapter = new LinkageSecondaryAdapter<T>(this.mInitItems, secondaryAdapterConfig);
        this.setLevel2LayoutManager();
        this.mRvSecondary.setAdapter((RecyclerView.Adapter)this.mSecondaryAdapter);
    }

    private void initLinkageSecondary() {
        if (this.mTvHeader == null && this.mSecondaryAdapter.getConfig() != null) {
            ILinkageSecondaryAdapterConfig config = this.mSecondaryAdapter.getConfig();
            int layout2 = config.getHeaderLayoutId();
            View view = LayoutInflater.from((Context)this.mContext).inflate(layout2, null);
            this.mHeaderContainer.addView(view);
            this.mTvHeader = (TextView)view.findViewById(config.getHeaderTextViewId());
        }
        if (this.mInitItems.get((int)this.mFirstVisiblePosition).isHeader) {
            this.mTvHeader.setText((CharSequence)this.mInitItems.get((int)this.mFirstVisiblePosition).header);
        }
        this.mRvSecondary.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                LinkageRecyclerView.this.mTitleHeight = LinkageRecyclerView.this.mTvHeader.getMeasuredHeight();
            }

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                View view;
                super.onScrolled(recyclerView, dx, dy);
                int firstPosition = LinkageRecyclerView.this.mSecondaryLayoutManager.findFirstVisibleItemPosition();
                int firstCompletePosition = LinkageRecyclerView.this.mSecondaryLayoutManager.findFirstCompletelyVisibleItemPosition();
                List items = LinkageRecyclerView.this.mSecondaryAdapter.getItems();
                if (firstCompletePosition > 0 && firstCompletePosition < items.size() && items.get((int)firstCompletePosition).isHeader && (view = LinkageRecyclerView.this.mSecondaryLayoutManager.findViewByPosition(firstCompletePosition)) != null && view.getTop() <= LinkageRecyclerView.this.mTitleHeight) {
                    LinkageRecyclerView.this.mTvHeader.setY((float)(view.getTop() - LinkageRecyclerView.this.mTitleHeight));
                }
                boolean groupNameChanged = false;
                if (LinkageRecyclerView.this.mFirstVisiblePosition != firstPosition && firstPosition >= 0) {
                    String currentGroupName;
                    LinkageRecyclerView.this.mFirstVisiblePosition = firstPosition;
                    LinkageRecyclerView.this.mTvHeader.setY(0.0f);
                    String string = currentGroupName = items.get((int)((LinkageRecyclerView)LinkageRecyclerView.this).mFirstVisiblePosition).isHeader ? items.get((int)((LinkageRecyclerView)LinkageRecyclerView.this).mFirstVisiblePosition).header : ((BaseGroupedItem.ItemInfo)items.get((int)((LinkageRecyclerView)LinkageRecyclerView.this).mFirstVisiblePosition).info).getGroup();
                    if (TextUtils.isEmpty((CharSequence)LinkageRecyclerView.this.mLastGroupName) || !LinkageRecyclerView.this.mLastGroupName.equals(currentGroupName)) {
                        LinkageRecyclerView.this.mLastGroupName = currentGroupName;
                        groupNameChanged = true;
                        LinkageRecyclerView.this.mTvHeader.setText((CharSequence)LinkageRecyclerView.this.mLastGroupName);
                    }
                }
                if (groupNameChanged) {
                    List<String> groupNames = LinkageRecyclerView.this.mPrimaryAdapter.getStrings();
                    for (int i = 0; i < groupNames.size(); ++i) {
                        if (!groupNames.get(i).equals(LinkageRecyclerView.this.mLastGroupName)) continue;
                        if (LinkageRecyclerView.this.mPrimaryClicked) {
                            if (LinkageRecyclerView.this.mPrimaryAdapter.getSelectedPosition() != i) continue;
                            LinkageRecyclerView.this.mPrimaryClicked = false;
                            continue;
                        }
                        LinkageRecyclerView.this.mPrimaryAdapter.setSelectedPosition(i);
                        RecyclerViewScrollHelper.smoothScrollToPosition(LinkageRecyclerView.this.mRvPrimary, 1, i);
                    }
                }
            }
        });
    }

    private int dpToPx(Context context, float dp) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)(dp * displayMetrics.density + 0.5f);
    }

    public void init(List<BaseGroupedItem<T>> linkageItems, ILinkagePrimaryAdapterConfig primaryAdapterConfig, ILinkageSecondaryAdapterConfig secondaryAdapterConfig) {
        this.initRecyclerView(primaryAdapterConfig, secondaryAdapterConfig);
        this.mInitItems = linkageItems;
        String lastGroupName = null;
        ArrayList<String> groupNames = new ArrayList<String>();
        if (this.mInitItems != null && this.mInitItems.size() > 0) {
            for (BaseGroupedItem<T> item1 : this.mInitItems) {
                if (!item1.isHeader) continue;
                groupNames.add(item1.header);
                lastGroupName = item1.header;
            }
        }
        if (this.mInitItems != null) {
            for (int i = 0; i < this.mInitItems.size(); ++i) {
                if (!this.mInitItems.get((int)i).isHeader) continue;
                this.mHeaderPositions.add(i);
            }
        }
        DefaultGroupedItem.ItemInfo info = new DefaultGroupedItem.ItemInfo(null, lastGroupName);
        DefaultGroupedItem footerItem = new DefaultGroupedItem(info);
        this.mInitItems.add(footerItem);
        this.mInitGroupNames = groupNames;
        this.mPrimaryAdapter.initData(this.mInitGroupNames);
        this.mSecondaryAdapter.initData(this.mInitItems);
        this.initLinkageSecondary();
    }

    public void init(List<BaseGroupedItem<T>> linkageItems) {
        this.init(linkageItems, new DefaultLinkagePrimaryAdapterConfig(), new DefaultLinkageSecondaryAdapterConfig());
    }

    public void setDefaultOnItemBindListener(DefaultLinkagePrimaryAdapterConfig.OnPrimaryItemClickListner primaryItemClickListner, DefaultLinkagePrimaryAdapterConfig.OnPrimaryItemBindListener primaryItemBindListener, DefaultLinkageSecondaryAdapterConfig.OnSecondaryItemBindListener secondaryItemBindListener, DefaultLinkageSecondaryAdapterConfig.OnSecondaryHeaderBindListener headerBindListener, DefaultLinkageSecondaryAdapterConfig.OnSecondaryFooterBindListener footerBindListener) {
        if (this.mPrimaryAdapter.getConfig() != null) {
            ((DefaultLinkagePrimaryAdapterConfig)this.mPrimaryAdapter.getConfig()).setListener(primaryItemBindListener, primaryItemClickListner);
        }
        if (this.mSecondaryAdapter.getConfig() != null) {
            ((DefaultLinkageSecondaryAdapterConfig)this.mSecondaryAdapter.getConfig()).setItemBindListener(secondaryItemBindListener, headerBindListener, footerBindListener);
        }
    }

    public void setLayoutHeight(float dp) {
        ViewGroup.LayoutParams lp = this.mLinkageLayout.getLayoutParams();
        lp.height = this.dpToPx(this.getContext(), dp);
        this.mLinkageLayout.setLayoutParams(lp);
    }

    public void setPrimaryWidget(float dp) {
        ViewGroup.LayoutParams lpLeft = this.mRvPrimary.getLayoutParams();
        lpLeft.width = this.dpToPx(this.getContext(), dp);
        this.mRvPrimary.setLayoutParams(lpLeft);
        ViewGroup.LayoutParams lpRight = this.mRvSecondary.getLayoutParams();
        lpRight.width = -1;
        this.mRvSecondary.setLayoutParams(lpRight);
    }

    public boolean isGridMode() {
        return this.mSecondaryAdapter.isGridMode();
    }

    public void setGridMode(boolean isGridMode) {
        this.mSecondaryAdapter.setGridMode(isGridMode);
        this.setLevel2LayoutManager();
        this.mRvSecondary.requestLayout();
    }

    public boolean isScrollSmoothly() {
        return this.mScrollSmoothly;
    }

    public void setScrollSmoothly(boolean scrollSmoothly) {
        this.mScrollSmoothly = scrollSmoothly;
    }

    public LinkagePrimaryAdapter getPrimaryAdapter() {
        return this.mPrimaryAdapter;
    }

    public LinkageSecondaryAdapter getSecondaryAdapter() {
        return this.mSecondaryAdapter;
    }

    public List<Integer> getHeaderPositions() {
        return this.mHeaderPositions;
    }

    public void setPercent(float percent) {
        Guideline guideline = (Guideline)this.view.findViewById(R.id.guideline);
        guideline.setGuidelinePercent(percent);
    }

    public void setRvPrimaryBackground(int resId) {
        this.mRvPrimary.setBackgroundResource(resId);
    }

    public void setRvSecondaryBackground(int resId) {
        this.mRvSecondary.setBackgroundResource(resId);
    }
}

