/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.linkage.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.kunminx.linkage.adapter.viewholder.LinkagePrimaryViewHolder;
import com.kunminx.linkage.contract.ILinkagePrimaryAdapterConfig;
import java.util.ArrayList;
import java.util.List;

public class LinkagePrimaryAdapter
extends RecyclerView.Adapter<LinkagePrimaryViewHolder> {
    private List<String> mStrings;
    private Context mContext;
    private View mView;
    private int mSelectedPosition;
    private ILinkagePrimaryAdapterConfig mConfig;
    private OnLinkageListener mLinkageListener;

    public List<String> getStrings() {
        return this.mStrings;
    }

    public ILinkagePrimaryAdapterConfig getConfig() {
        return this.mConfig;
    }

    public int getSelectedPosition() {
        return this.mSelectedPosition;
    }

    public void setSelectedPosition(int selectedPosition) {
        this.mSelectedPosition = selectedPosition;
        this.notifyDataSetChanged();
    }

    public LinkagePrimaryAdapter(List<String> strings, ILinkagePrimaryAdapterConfig config, OnLinkageListener linkageListener) {
        this.mStrings = strings;
        if (this.mStrings == null) {
            this.mStrings = new ArrayList<String>();
        }
        this.mConfig = config;
        this.mLinkageListener = linkageListener;
    }

    public void initData(List<String> list) {
        this.mStrings.clear();
        if (list != null) {
            this.mStrings.addAll(list);
        }
        this.notifyDataSetChanged();
    }

    @NonNull
    public LinkagePrimaryViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.mContext = parent.getContext();
        this.mConfig.setContext(this.mContext);
        this.mView = LayoutInflater.from((Context)this.mContext).inflate(this.mConfig.getLayoutId(), parent, false);
        return new LinkagePrimaryViewHolder(this.mView, this.mConfig);
    }

    public void onBindViewHolder(final @NonNull LinkagePrimaryViewHolder holder, int position) {
        holder.mLayout.setSelected(true);
        int adapterPosition = holder.getBindingAdapterPosition();
        final String title = this.mStrings.get(adapterPosition);
        this.mConfig.onBindViewHolder(holder, adapterPosition == this.mSelectedPosition, title);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LinkagePrimaryAdapter.this.mLinkageListener != null) {
                    LinkagePrimaryAdapter.this.mLinkageListener.onLinkageClick(holder, title);
                }
                LinkagePrimaryAdapter.this.mConfig.onItemClick(holder, v, title);
            }
        });
    }

    public int getItemCount() {
        return this.mStrings.size();
    }

    public static interface OnLinkageListener {
        public void onLinkageClick(LinkagePrimaryViewHolder var1, String var2);
    }
}

