/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.linkage.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.kunminx.linkage.R;
import com.kunminx.linkage.adapter.viewholder.LinkageSecondaryFooterViewHolder;
import com.kunminx.linkage.adapter.viewholder.LinkageSecondaryHeaderViewHolder;
import com.kunminx.linkage.adapter.viewholder.LinkageSecondaryViewHolder;
import com.kunminx.linkage.bean.BaseGroupedItem;
import com.kunminx.linkage.contract.ILinkageSecondaryAdapterConfig;
import java.util.ArrayList;
import java.util.List;

public class LinkageSecondaryAdapter<T extends BaseGroupedItem.ItemInfo>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Context mContext;
    private List<BaseGroupedItem<T>> mItems;
    private static final int IS_HEADER = 0;
    private static final int IS_LINEAR = 1;
    private static final int IS_GRID = 2;
    private static final int IS_FOOTER = 3;
    private boolean mIsGridMode;
    private ILinkageSecondaryAdapterConfig mConfig;

    public ILinkageSecondaryAdapterConfig getConfig() {
        return this.mConfig;
    }

    public List<BaseGroupedItem<T>> getItems() {
        return this.mItems;
    }

    public boolean isGridMode() {
        return this.mIsGridMode && this.mConfig.getGridLayoutId() != 0;
    }

    public void setGridMode(boolean isGridMode) {
        this.mIsGridMode = isGridMode;
    }

    public LinkageSecondaryAdapter(List<BaseGroupedItem<T>> items, ILinkageSecondaryAdapterConfig config) {
        this.mItems = items;
        if (this.mItems == null) {
            this.mItems = new ArrayList<BaseGroupedItem<T>>();
        }
        this.mConfig = config;
    }

    public void initData(List<BaseGroupedItem<T>> list) {
        this.mItems.clear();
        if (list != null) {
            this.mItems.addAll(list);
        }
        this.notifyDataSetChanged();
    }

    public int getItemViewType(int position) {
        if (this.mItems.get((int)position).isHeader) {
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)((BaseGroupedItem.ItemInfo)this.mItems.get((int)position).info).getTitle()) && !TextUtils.isEmpty((CharSequence)((BaseGroupedItem.ItemInfo)this.mItems.get((int)position).info).getGroup())) {
            return 3;
        }
        if (this.isGridMode()) {
            return 2;
        }
        return 1;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.mContext = parent.getContext();
        this.mConfig.setContext(this.mContext);
        if (viewType == 0) {
            View view = LayoutInflater.from((Context)this.mContext).inflate(this.mConfig.getHeaderLayoutId(), parent, false);
            return new LinkageSecondaryHeaderViewHolder(view);
        }
        if (viewType == 3) {
            int footerLayout = this.mConfig.getFooterLayoutId() == 0 ? R.layout.default_adapter_linkage_secondary_footer : this.mConfig.getFooterLayoutId();
            View view = LayoutInflater.from((Context)this.mContext).inflate(footerLayout, parent, false);
            return new LinkageSecondaryFooterViewHolder(view);
        }
        if (viewType == 2 && this.mConfig.getGridLayoutId() != 0) {
            View view = LayoutInflater.from((Context)this.mContext).inflate(this.mConfig.getGridLayoutId(), parent, false);
            return new LinkageSecondaryViewHolder(view);
        }
        View view = LayoutInflater.from((Context)this.mContext).inflate(this.mConfig.getLinearLayoutId(), parent, false);
        return new LinkageSecondaryViewHolder(view);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        BaseGroupedItem<T> linkageItem = this.mItems.get(holder.getBindingAdapterPosition());
        if (this.getItemViewType(holder.getBindingAdapterPosition()) == 0) {
            LinkageSecondaryHeaderViewHolder headerViewHolder = (LinkageSecondaryHeaderViewHolder)holder;
            this.mConfig.onBindHeaderViewHolder(headerViewHolder, linkageItem);
        } else if (this.getItemViewType(holder.getBindingAdapterPosition()) == 3) {
            LinkageSecondaryFooterViewHolder footerViewHolder = (LinkageSecondaryFooterViewHolder)holder;
            this.mConfig.onBindFooterViewHolder(footerViewHolder, linkageItem);
        } else {
            LinkageSecondaryViewHolder secondaryViewHolder = (LinkageSecondaryViewHolder)holder;
            this.mConfig.onBindViewHolder(secondaryViewHolder, linkageItem);
        }
    }

    public int getItemCount() {
        return this.mItems.size();
    }
}

