/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.linkage.defaults;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.kunminx.linkage.R;
import com.kunminx.linkage.adapter.viewholder.LinkagePrimaryViewHolder;
import com.kunminx.linkage.contract.ILinkagePrimaryAdapterConfig;

public class DefaultLinkagePrimaryAdapterConfig
implements ILinkagePrimaryAdapterConfig {
    private static final int MARQUEE_REPEAT_LOOP_MODE = -1;
    private static final int MARQUEE_REPEAT_NONE_MODE = 0;
    private Context mContext;
    private OnPrimaryItemBindListener mListener;
    private OnPrimaryItemClickListner mClickListner;

    public void setListener(OnPrimaryItemBindListener listener, OnPrimaryItemClickListner clickListner) {
        this.mListener = listener;
        this.mClickListner = clickListner;
    }

    @Override
    public void setContext(Context context) {
        this.mContext = context;
    }

    @Override
    public int getLayoutId() {
        return R.layout.default_adapter_linkage_primary;
    }

    @Override
    public int getGroupTitleViewId() {
        return R.id.tv_group;
    }

    @Override
    public int getRootViewId() {
        return R.id.layout_group;
    }

    @Override
    public void onBindViewHolder(LinkagePrimaryViewHolder holder, boolean selected, String title) {
        TextView tvTitle = (TextView)holder.mGroupTitle;
        tvTitle.setText((CharSequence)title);
        tvTitle.setBackgroundColor(this.mContext.getResources().getColor(selected ? R.color.colorPurple : R.color.colorWhite));
        tvTitle.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)(selected ? R.color.colorWhite : R.color.colorGray)));
        tvTitle.setEllipsize(selected ? TextUtils.TruncateAt.MARQUEE : TextUtils.TruncateAt.END);
        tvTitle.setFocusable(selected);
        tvTitle.setFocusableInTouchMode(selected);
        tvTitle.setMarqueeRepeatLimit(selected ? -1 : 0);
        if (this.mListener != null) {
            this.mListener.onBindViewHolder(holder, title);
        }
    }

    @Override
    public void onItemClick(LinkagePrimaryViewHolder holder, View view, String title) {
        if (this.mClickListner != null) {
            this.mClickListner.onItemClick(holder, view, title);
        }
    }

    public static interface OnPrimaryItemBindListener {
        public void onBindViewHolder(LinkagePrimaryViewHolder var1, String var2);
    }

    public static interface OnPrimaryItemClickListner {
        public void onItemClick(LinkagePrimaryViewHolder var1, View var2, String var3);
    }
}

