/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.linkage.defaults;

import android.content.Context;
import android.widget.TextView;
import com.kunminx.linkage.R;
import com.kunminx.linkage.adapter.viewholder.LinkageSecondaryFooterViewHolder;
import com.kunminx.linkage.adapter.viewholder.LinkageSecondaryHeaderViewHolder;
import com.kunminx.linkage.adapter.viewholder.LinkageSecondaryViewHolder;
import com.kunminx.linkage.bean.BaseGroupedItem;
import com.kunminx.linkage.bean.DefaultGroupedItem;
import com.kunminx.linkage.contract.ILinkageSecondaryAdapterConfig;

public class DefaultLinkageSecondaryAdapterConfig
implements ILinkageSecondaryAdapterConfig<DefaultGroupedItem.ItemInfo> {
    private Context mContext;
    private OnSecondaryItemBindListener mItemBindListener;
    private OnSecondaryHeaderBindListener mHeaderBindListener;
    private OnSecondaryFooterBindListener mFooterBindListener;
    private static final int SPAN_COUNT = 3;

    public void setItemBindListener(OnSecondaryItemBindListener itemBindListener, OnSecondaryHeaderBindListener headerBindListener, OnSecondaryFooterBindListener footerBindListener) {
        this.mItemBindListener = itemBindListener;
        this.mHeaderBindListener = headerBindListener;
        this.mFooterBindListener = footerBindListener;
    }

    @Override
    public void setContext(Context context) {
        this.mContext = context;
    }

    @Override
    public int getGridLayoutId() {
        return R.layout.default_adapter_linkage_secondary_grid;
    }

    @Override
    public int getLinearLayoutId() {
        return R.layout.default_adapter_linkage_secondary_linear;
    }

    @Override
    public int getHeaderLayoutId() {
        return R.layout.default_adapter_linkage_secondary_header;
    }

    @Override
    public int getFooterLayoutId() {
        return R.layout.default_adapter_linkage_secondary_footer;
    }

    @Override
    public int getHeaderTextViewId() {
        return R.id.secondary_header;
    }

    @Override
    public int getSpanCountOfGridMode() {
        return 3;
    }

    @Override
    public void onBindViewHolder(LinkageSecondaryViewHolder holder, BaseGroupedItem<DefaultGroupedItem.ItemInfo> item) {
        ((TextView)holder.getView(R.id.level_2_title)).setText((CharSequence)((DefaultGroupedItem.ItemInfo)item.info).getTitle());
        ((TextView)holder.getView(R.id.level_2_content)).setText((CharSequence)((DefaultGroupedItem.ItemInfo)item.info).getContent());
        if (this.mItemBindListener != null) {
            this.mItemBindListener.onBindViewHolder(holder, item);
        }
    }

    @Override
    public void onBindHeaderViewHolder(LinkageSecondaryHeaderViewHolder holder, BaseGroupedItem<DefaultGroupedItem.ItemInfo> item) {
        ((TextView)holder.getView(R.id.secondary_header)).setText((CharSequence)item.header);
        if (this.mHeaderBindListener != null) {
            this.mHeaderBindListener.onBindHeaderViewHolder(holder, item);
        }
    }

    @Override
    public void onBindFooterViewHolder(LinkageSecondaryFooterViewHolder holder, BaseGroupedItem<DefaultGroupedItem.ItemInfo> item) {
        ((TextView)holder.getView(R.id.tv_secondary_footer)).setText((CharSequence)this.mContext.getString(R.string.the_end));
        if (this.mFooterBindListener != null) {
            this.mFooterBindListener.onBindFooterViewHolder(holder, item);
        }
    }

    public static interface OnSecondaryFooterBindListener {
        public void onBindFooterViewHolder(LinkageSecondaryFooterViewHolder var1, BaseGroupedItem<DefaultGroupedItem.ItemInfo> var2);
    }

    public static interface OnSecondaryHeaderBindListener {
        public void onBindHeaderViewHolder(LinkageSecondaryHeaderViewHolder var1, BaseGroupedItem<DefaultGroupedItem.ItemInfo> var2);
    }

    public static interface OnSecondaryItemBindListener {
        public void onBindViewHolder(LinkageSecondaryViewHolder var1, BaseGroupedItem<DefaultGroupedItem.ItemInfo> var2);
    }
}

