/*
 * Decompiled with CFR 0.152.
 */
package com.kylewm.mf2j;

import com.kylewm.mf2j.JsonList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonDict
extends HashMap<String, Object> {
    private static final long serialVersionUID = 3604372225030827955L;

    public JsonDict() {
    }

    public JsonDict(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public JsonDict(int initialCapacity) {
        super(initialCapacity);
    }

    public JsonDict(Map<? extends String, ? extends Object> m) {
        super(m);
    }

    public JsonDict getDict(String key) {
        return (JsonDict)this.get(key);
    }

    public JsonList getList(String key) {
        return (JsonList)this.get(key);
    }

    public JsonDict getOrCreateDict(String key) {
        JsonDict dict = (JsonDict)this.get(key);
        if (dict == null) {
            dict = new JsonDict();
            this.put(key, dict);
        }
        return dict;
    }

    public JsonList getOrCreateList(String key) {
        JsonList list = (JsonList)this.get(key);
        if (list == null) {
            list = new JsonList();
            this.put(key, list);
        }
        return list;
    }

    public static String escapeString(String str) {
        return str.replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        ArrayList keys = new ArrayList(this.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + JsonDict.escapeString(key) + "\":");
            Object value = this.get(key);
            if (value instanceof String) {
                sb.append("\"" + JsonDict.escapeString((String)value) + "\"");
                continue;
            }
            sb.append(value);
        }
        sb.append("}");
        return sb.toString();
    }
}

