/*
 * Decompiled with CFR 0.152.
 */
package com.kylewm.mf2j;

import com.kylewm.mf2j.JsonDict;
import com.kylewm.mf2j.JsonList;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Mf2Parser {
    private boolean includeAlternates = true;
    private boolean includeRelUrls = false;

    public Mf2Parser setIncludeAlternates(boolean includeAlts) {
        this.includeAlternates = includeAlts;
        return this;
    }

    public Mf2Parser setIncludeRelUrls(boolean includeRelUrls) {
        this.includeRelUrls = includeRelUrls;
        return this;
    }

    public JsonDict parse(URI resource) throws IOException {
        Document text = Jsoup.connect((String)resource.toString()).get();
        return this.parse(text, resource);
    }

    public JsonDict parse(String html, URI baseUri) {
        Document doc = Jsoup.parse((String)html);
        return this.parse(doc, baseUri);
    }

    private URI findBaseUri(Document doc, URI baseUri) {
        Element base = doc.getElementsByTag("base").first();
        if (base != null && base.hasAttr("href")) {
            return baseUri.resolve(base.attr("href"));
        }
        return baseUri;
    }

    public JsonDict parse(Document doc, URI baseUri) {
        baseUri = this.findBaseUri(doc, baseUri);
        JsonDict dict = new JsonDict();
        JsonList items = dict.getOrCreateList("items");
        this.parseMicroformats((Element)doc, baseUri, items);
        this.parseRels(doc, baseUri, dict);
        return dict;
    }

    private void parseRels(Document doc, URI baseUri, JsonDict dict) {
        dict.getOrCreateDict("rels");
        if (this.includeRelUrls) {
            dict.getOrCreateDict("rel-urls");
        }
        for (Element link : doc.select("a[rel][href],link[rel][href]")) {
            String relStr = link.attr("rel");
            String href = link.attr("href");
            href = baseUri.resolve(href).toString();
            JsonList rels = new JsonList();
            String[] stringArray = relStr.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String rel = stringArray[n2];
                if (!(rel = rel.trim()).isEmpty()) {
                    rels.add(rel);
                }
                ++n2;
            }
            if (this.includeAlternates && rels.contains("alternate")) {
                String relNoAlt = Pattern.compile("(^|\\s+)alternate(\\s+|$)").matcher(relStr).replaceAll(" ").trim();
                JsonDict altDict = new JsonDict();
                altDict.put("url", href);
                altDict.put("rel", relNoAlt);
                for (String attr : Arrays.asList("hreflang", "media", "type", "title")) {
                    if (!link.hasAttr(attr)) continue;
                    altDict.put(attr, link.attr(attr));
                }
                String textContent = link.text().trim();
                if (!textContent.isEmpty()) {
                    altDict.put("text", textContent);
                }
                dict.getOrCreateList("alternates").add(altDict);
                continue;
            }
            for (String rel : rels) {
                dict.getDict("rels").getOrCreateList(rel).add(href);
            }
            if (!this.includeRelUrls) continue;
            JsonDict urlDict = dict.getDict("rel-urls").getOrCreateDict(href);
            urlDict.put("rels", rels);
            for (String attr : Arrays.asList("hreflang", "media", "type", "title")) {
                if (!link.hasAttr(attr)) continue;
                urlDict.put(attr, link.attr(attr));
            }
            String textContent = link.text().trim();
            if (textContent.isEmpty()) continue;
            urlDict.put("text", textContent);
        }
    }

    private void parseMicroformats(Element elem, URI baseUri, JsonList items) {
        if (this.hasRootClass(elem)) {
            JsonDict itemDict = this.parseMicroformat(elem, baseUri);
            items.add(itemDict);
        } else {
            for (Element child : elem.children()) {
                this.parseMicroformats(child, baseUri, items);
            }
        }
    }

    private JsonDict parseMicroformat(Element elem, URI baseUri) {
        String impliedPhoto;
        String impliedUrl;
        String impliedName;
        JsonDict itemDict = new JsonDict();
        itemDict.put("type", this.getRootClasses(elem));
        JsonDict properties = itemDict.getOrCreateDict("properties");
        for (Element child : elem.children()) {
            this.parseProperties(child, baseUri, itemDict);
        }
        if (!properties.containsKey("name") && (impliedName = this.parseImpliedName(elem)) != null) {
            JsonList implNameList = new JsonList();
            implNameList.add(impliedName);
            properties.put("name", implNameList);
        }
        if (!properties.containsKey("url") && (impliedUrl = this.parseImpliedUrl(elem, baseUri)) != null) {
            JsonList implUrlList = new JsonList();
            implUrlList.add(impliedUrl);
            properties.put("url", implUrlList);
        }
        if (!properties.containsKey("photo") && (impliedPhoto = this.parseImpliedPhoto(elem, baseUri)) != null) {
            JsonList implPhotoList = new JsonList();
            implPhotoList.add(impliedPhoto);
            properties.put("photo", implPhotoList);
        }
        return itemDict;
    }

    private void parseProperties(Element elem, URI baseUri, JsonDict itemDict) {
        boolean isProperty = false;
        boolean isMicroformat = false;
        JsonDict valueObj = null;
        if (this.hasRootClass(elem)) {
            valueObj = this.parseMicroformat(elem, baseUri);
            isMicroformat = true;
        }
        for (String className : elem.classNames()) {
            String propName = null;
            Object value = null;
            if (className.startsWith("p-")) {
                propName = className.substring(2);
                value = this.parseTextProperty(elem);
                isProperty = true;
            } else if (className.startsWith("u-")) {
                propName = className.substring(2);
                value = this.parseUrlProperty(elem, baseUri);
                isProperty = true;
            } else if (className.startsWith("dt-")) {
                propName = className.substring(3);
                value = this.parseDateTimeProperty(elem);
                isProperty = true;
            } else if (className.startsWith("e-")) {
                propName = className.substring(2);
                value = this.parseHtmlProperty(elem);
                isProperty = true;
            }
            if (propName == null) continue;
            if (isMicroformat && valueObj != null) {
                JsonDict copy = new JsonDict(valueObj);
                copy.put("value", value);
                value = copy;
            }
            itemDict.getDict("properties").getOrCreateList(propName).add(value);
        }
        if (!isProperty && isMicroformat) {
            itemDict.getOrCreateList("children").add(valueObj);
        }
        if (!isProperty && !isMicroformat) {
            for (Element child : elem.children()) {
                this.parseProperties(child, baseUri, itemDict);
            }
        }
    }

    private String parseTextProperty(Element elem) {
        if ("abbr".equals(elem.tagName()) && elem.hasAttr("title")) {
            return elem.attr("title");
        }
        if (("data".equals(elem.tagName()) || "input".equals(elem.tagName())) && elem.hasAttr("value")) {
            return elem.attr("value");
        }
        if (("img".equals(elem.tagName()) || "area".equals(elem.tagName())) && elem.hasAttr("alt")) {
            return elem.attr("alt");
        }
        return elem.text().trim();
    }

    private String parseUrlProperty(Element elem, URI baseUri) {
        String url = null;
        if (("a".equals(elem.tagName()) || "area".equals(elem.tagName())) && elem.hasAttr("href")) {
            url = elem.attr("href");
        }
        if (("img".equals(elem.tagName()) || "audio".equals(elem.tagName()) || "video".equals(elem.tagName()) || "source".equals(elem.tagName())) && elem.hasAttr("src")) {
            url = elem.attr("src");
        }
        if ("object".equals(elem.tagName()) && elem.hasAttr("data")) {
            url = elem.attr("data");
        }
        if (url != null) {
            return baseUri.resolve(url).toString();
        }
        if ("abbr".equals(elem.tagName()) && elem.hasAttr("title")) {
            return elem.attr("title");
        }
        if (("data".equals(elem.tagName()) || "input".equals(elem.tagName())) && elem.hasAttr("value")) {
            return elem.attr("value");
        }
        return elem.text().trim();
    }

    private String parseDateTimeProperty(Element elem) {
        if (("time".equals(elem.tagName()) || "ins".equals(elem.tagName()) || "del".equals(elem.tagName())) && elem.hasAttr("datetime")) {
            return elem.attr("datetime");
        }
        if ("abbr".equals(elem.tagName()) && elem.hasAttr("title")) {
            return elem.attr("title");
        }
        if (("data".equals(elem.tagName()) || "input".equals(elem.tagName())) && elem.hasAttr("value")) {
            return elem.attr("value");
        }
        return elem.text().trim();
    }

    private JsonDict parseHtmlProperty(Element elem) {
        JsonDict dict = new JsonDict();
        dict.put("html", elem.html());
        dict.put("text", elem.text());
        return dict;
    }

    private String parseImpliedPhoto(Element elem, URI baseUri) {
        String href = this.parseImpliedPhotoRelative(elem);
        if (href != null) {
            return baseUri.resolve(href).toString();
        }
        return null;
    }

    private String parseImpliedPhotoRelative(Element elem) {
        String attr;
        String tag;
        String[] tagAttr;
        String[][] tagAttrs;
        String[][] stringArrayArray = tagAttrs = new String[][]{{"img", "src"}, {"object", "data"}};
        int n = tagAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            tagAttr = stringArrayArray[n2];
            tag = tagAttr[0];
            attr = tagAttr[1];
            if (tag.equals(elem.tagName()) && elem.hasAttr(attr)) {
                return elem.attr(attr);
            }
            ++n2;
        }
        stringArrayArray = tagAttrs;
        n = tagAttrs.length;
        n2 = 0;
        while (n2 < n) {
            Element child;
            tagAttr = stringArrayArray[n2];
            tag = tagAttr[0];
            attr = tagAttr[1];
            Elements children = this.filterByTag(elem.children(), tag);
            if (children.size() == 1 && !this.hasRootClass(child = children.first()) && child.hasAttr(attr)) {
                return child.attr(attr);
            }
            ++n2;
        }
        Elements children = elem.children();
        if (children.size() == 1) {
            Element child = children.first();
            String[][] stringArrayArray2 = tagAttrs;
            int n3 = tagAttrs.length;
            int n4 = 0;
            while (n4 < n3) {
                Element grandChild;
                String[] tagAttr2 = stringArrayArray2[n4];
                String tag2 = tagAttr2[0];
                String attr2 = tagAttr2[1];
                Elements grandChildren = this.filterByTag(child.children(), tag2);
                if (grandChildren.size() == 1 && !this.hasRootClass(grandChild = grandChildren.first()) && grandChild.hasAttr(attr2)) {
                    return grandChild.attr(attr2);
                }
                ++n4;
            }
        }
        return null;
    }

    private String parseImpliedUrl(Element elem, URI baseUri) {
        String href = this.parseImpliedUrlRelative(elem);
        if (href != null) {
            return baseUri.resolve(href).toString();
        }
        return null;
    }

    private String parseImpliedUrlRelative(Element elem) {
        if (("a".equals(elem.tagName()) || "area".equals(elem.tagName())) && elem.hasAttr("href")) {
            return elem.attr("href");
        }
        for (String childTag : Arrays.asList("a", "area")) {
            Element child;
            Elements children = this.filterByTag(elem.children(), childTag);
            if (children.size() != 1 || this.hasRootClass(child = children.first()) || !child.hasAttr("href")) continue;
            return child.attr("href");
        }
        return null;
    }

    private String parseImpliedName(Element elem) {
        if ("img".equals(elem.tagName()) || "area".equals(elem.tagName()) && elem.hasAttr("alt")) {
            return elem.attr("alt");
        }
        if ("abbr".equals(elem.tagName()) && elem.hasAttr("title")) {
            return elem.attr("title");
        }
        Elements children = elem.children();
        if (children.size() == 1) {
            Element child = children.first();
            if (!this.hasRootClass(child) && ("img".equals(child.tagName()) || "area".equals(child.tagName())) && child.hasAttr("alt")) {
                return child.attr("alt");
            }
            if ("abbr".equals(child.tagName()) && child.hasAttr("title")) {
                return child.attr("title");
            }
            Elements grandChildren = child.children();
            if (grandChildren.size() == 1) {
                Element grandChild = grandChildren.first();
                if (!this.hasRootClass(grandChild) && ("img".equals(grandChild.tagName()) || "area".equals(grandChild.tagName())) && grandChild.hasAttr("alt")) {
                    return grandChild.attr("alt");
                }
                if ("abbr".equals(grandChild.tagName()) && grandChild.hasAttr("c")) {
                    return grandChild.attr("title");
                }
            }
        }
        return elem.text().trim();
    }

    private Elements filterByTag(Elements elems, String tag) {
        Elements filtered = new Elements();
        for (Element child : elems) {
            if (!tag.equals(child.tagName())) continue;
            filtered.add((Object)child);
        }
        return filtered;
    }

    private JsonList getRootClasses(Element elem) {
        ArrayList rootClasses = null;
        for (String className : elem.classNames()) {
            if (!this.isRootClass(className)) continue;
            if (rootClasses == null) {
                rootClasses = new JsonList();
            }
            rootClasses.add(className);
        }
        return rootClasses;
    }

    private boolean hasRootClass(Element elem) {
        for (String className : elem.classNames()) {
            if (!this.isRootClass(className)) continue;
            return true;
        }
        return false;
    }

    private boolean isRootClass(String className) {
        return className.startsWith("h-");
    }
}

