/*
 * Decompiled with CFR 0.152.
 */
package com.laamella.mpu6502;

import com.laamella.mpu6502.Bus;
import com.laamella.mpu6502.Mpu6502Specifications;
import com.laamella.mpu6502.RunState;

public final class Mpu6502 {
    private Ref aRef = new Ref(){

        @Override
        public int get() {
            return Mpu6502.this.a;
        }

        @Override
        public void set(int value) {
            Mpu6502.this.a = value;
        }

        public String toString() {
            return "A (= " + Mpu6502.this.a + ")";
        }
    };
    private Ref xRef = new Ref(){

        @Override
        public int get() {
            return Mpu6502.this.x;
        }

        @Override
        public void set(int value) {
            Mpu6502.this.x = value;
        }

        public String toString() {
            return "X (= " + Mpu6502.this.x + ")";
        }
    };
    private Ref yRef = new Ref(){

        @Override
        public int get() {
            return Mpu6502.this.y;
        }

        @Override
        public void set(int value) {
            Mpu6502.this.y = value;
        }

        public String toString() {
            return "Y (= " + Mpu6502.this.y + ")";
        }
    };
    private Ref spRef = new Ref(){

        @Override
        public int get() {
            return Mpu6502.this.sp;
        }

        @Override
        public void set(int value) {
            Mpu6502.this.sp = value;
        }

        public String toString() {
            return "SP (= " + Mpu6502.this.sp + ")";
        }
    };
    public int a = 0;
    public int x = 0;
    public int y = 0;
    public int flags = 0;
    public int sp = 255;
    public int pc = 0;
    public int cycles = 0;
    public final Bus bus;

    public Mpu6502(Bus bus) {
        this.bus = bus;
    }

    private boolean isSet(int val, int mask) {
        return (val & mask) > 0;
    }

    private boolean zero(int val) {
        return val == 0;
    }

    private Pointer lo() {
        return new Pointer(this.pc);
    }

    private Pointer hi() {
        return new Pointer(this.pc + 1);
    }

    private int fetch() {
        return this.bus.read(this.pc++);
    }

    public void push(int data) {
        this.bus.write(256 + this.sp, data);
        this.sp = this.sp - 1 & 0xFF;
    }

    public int pop() {
        this.sp = this.sp + 1 & 0xFF;
        return this.bus.read(256 + this.sp);
    }

    private Pointer immediate() {
        return this.lo();
    }

    private Pointer absolute() {
        return new Pointer(this.lo().get() | this.hi().get() << 8);
    }

    private Pointer absoluteX() {
        return new Pointer((this.lo().get() | this.hi().get() << 8) + this.x & 0xFFFF);
    }

    private Pointer absoluteY() {
        return new Pointer((this.lo().get() | this.hi().get() << 8) + this.y & 0xFFFF);
    }

    private Pointer zeropage() {
        return new Pointer(this.lo().get() & 0xFF);
    }

    private Pointer zeropageX() {
        return new Pointer(this.lo().get() + this.x & 0xFF);
    }

    private Pointer zeropageY() {
        return new Pointer(this.lo().get() + this.y & 0xFF);
    }

    private Pointer indirectX() {
        return new Pointer(this.bus.read(this.lo().get() + this.x & 0xFF) | this.bus.read(this.lo().get() + this.x + 1 & 0xFF) << 8);
    }

    private Pointer indirectY() {
        return new Pointer((this.bus.read(this.lo().get()) | this.bus.read(this.lo().get() + 1 & 0xFF) << 8) + this.y & 0xFFFF);
    }

    private Pointer indirectZP() {
        return new Pointer((this.bus.read(this.lo().get()) | this.bus.read(this.lo().get() + 1 & 0xFF) << 8) & 0xFFFF);
    }

    private int evalPagecrossing(Pointer baseaddr, Pointer realaddr) {
        return this.isSet(baseaddr.address ^ realaddr.address, 65280) ? 1 : 0;
    }

    private int evalPagecrossingAbsoluteX() {
        return this.evalPagecrossing(this.absolute(), this.absoluteX());
    }

    private int evalPagecrossingAbsoluteY() {
        return this.evalPagecrossing(this.absolute(), this.absoluteY());
    }

    private int evalPagecrossingIndirectY() {
        return this.evalPagecrossing(this.indirectZP(), this.indirectY());
    }

    private Pointer ref(int address) {
        return new Pointer(address);
    }

    private void branch() {
        ++this.cycles;
        int temp = this.fetch();
        if (temp < 128) {
            this.cycles += this.evalPagecrossing(this.ref(this.pc), this.ref(this.pc + temp));
            this.pc += temp;
        } else {
            this.cycles += this.evalPagecrossing(this.ref(this.pc), this.ref(this.pc + temp - 256));
            this.pc += temp - 256;
        }
    }

    private void assignAndSetFlags(Ref ref, Ref dataRef) {
        this.assignAndSetFlags(ref, dataRef.get());
    }

    private void assignAndSetFlags(Ref ref, int data) {
        ref.set(data &= 0xFF);
        this.setFlags(data);
    }

    private void setFlags(int data) {
        this.flags = this.zero(data) ? this.flags & 0xFFFFFF7F | 2 : this.flags & 0xFFFFFF7D | data & 0x80;
    }

    private void ADC(Ref ref) {
        int temp;
        int data = ref.get();
        if (this.isSet(this.flags, 8)) {
            temp = (this.a & 0xF) + (data & 0xF) + (this.flags & 1);
            if (temp > 9) {
                temp += 6;
            }
            temp = temp <= 15 ? (temp & 0xF) + (this.a & 0xF0) + (data & 0xF0) : (temp & 0xF) + (this.a & 0xF0) + (data & 0xF0) + 16;
            this.flags = !this.isSet(this.a + data + (this.flags & 1), 255) ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
            this.flags = this.isSet(temp, 128) ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
            this.flags = this.isSet(this.a ^ temp, 128) && !this.isSet(this.a ^ data, 128) ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
            if ((temp & 0x1F0) > 144) {
                temp += 96;
            }
            this.flags = (temp & 0xFF0) > 240 ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        } else {
            temp = data + this.a + (this.flags & 1);
            this.setFlags(temp & 0xFF);
            this.flags = !this.isSet(this.a ^ data, 128) && this.isSet(this.a ^ temp, 128) ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
            this.flags = temp > 255 ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        }
        this.a = temp & 0xFF;
    }

    private void SBC(Ref dataRef) {
        int data = dataRef.get();
        int temp = this.a - data - (this.flags & 1 ^ 1);
        if (this.isSet(this.flags, 8)) {
            int tempval2 = (this.a & 0xF) - (data & 0xF) - (this.flags & 1 ^ 1);
            tempval2 = this.isSet(tempval2, 16) ? tempval2 - 6 & 0xF | (this.a & 0xF0) - (data & 0xF0) - 16 : tempval2 & 0xF | (this.a & 0xF0) - (data & 0xF0);
            if (this.isSet(tempval2, 256)) {
                tempval2 -= 96;
            }
            this.flags = temp < 0 ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
            this.setFlags(temp & 0xFF);
            this.flags = this.isSet(this.a ^ temp, 128) && this.isSet(this.a ^ data, 128) ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
            this.a = tempval2 & 0xFF;
        } else {
            this.setFlags(temp & 0xFF);
            this.flags = temp < 0 ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
            this.flags = this.isSet(this.a ^ temp, 128) && this.isSet(this.a ^ data, 128) ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
            this.a = temp & 0xFF;
        }
    }

    private void CMP(Ref src, Ref data) {
        int temp = src.get() - data.get() & 0xFF;
        this.flags = this.flags & 0xFFFFFF7C | temp & 0x80;
        if (this.zero(temp)) {
            this.flags |= 2;
        }
        if (src.get() >= data.get()) {
            this.flags |= 1;
        }
    }

    private void ASL(Ref data) {
        int temp = data.get();
        this.flags = this.isSet(temp <<= 1, 256) ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        this.assignAndSetFlags(data, temp);
    }

    private void LSR(Ref data) {
        int temp = data.get();
        this.flags = this.isSet(temp, 1) ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        this.assignAndSetFlags(data, temp >>= 1);
    }

    private void ROL(Ref data) {
        int temp = data.get();
        temp <<= 1;
        if (this.isSet(this.flags, 1)) {
            temp |= 1;
        }
        this.flags = this.isSet(temp, 256) ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        this.assignAndSetFlags(data, temp);
    }

    private void ROR(Ref data) {
        int temp = data.get();
        if (this.isSet(this.flags, 1)) {
            temp |= 0x100;
        }
        this.flags = this.isSet(temp, 1) ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        this.assignAndSetFlags(data, temp >>= 1);
    }

    private void DEC(Ref data) {
        int temp = data.get() - 1;
        this.assignAndSetFlags(data, temp);
    }

    private void INC(Ref data) {
        int temp = data.get() + 1;
        this.assignAndSetFlags(data, temp);
    }

    private void EOR(Ref data) {
        this.a ^= data.get();
        this.setFlags(this.a);
    }

    private void ORA(Ref data) {
        this.a |= data.get();
        this.setFlags(this.a);
    }

    private void AND(Ref data) {
        this.a &= data.get();
        this.setFlags(this.a);
    }

    private void BIT(Ref dataRef) {
        int data = dataRef.get();
        this.flags = this.flags & 0xFFFFFF3F | data & 0xC0;
        this.flags = !this.isSet(data, this.a) ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public RunState step() {
        int op = this.fetch();
        this.cycles += Mpu6502Specifications.CPU_CYCLES[op];
        if (Mpu6502Specifications.ADDRESSING_MODE[op] == Mpu6502Specifications.AddressingMode.JAM) {
            return RunState.JAMMED;
        }
        switch (op) {
            case 167: {
                this.assignAndSetFlags(this.aRef, this.zeropage().get());
                this.x = this.a;
                ++this.pc;
                break;
            }
            case 183: {
                this.assignAndSetFlags(this.aRef, this.zeropageY().get());
                this.x = this.a;
                ++this.pc;
                break;
            }
            case 175: {
                this.assignAndSetFlags(this.aRef, this.absolute().get());
                this.x = this.a;
                this.pc += 2;
                break;
            }
            case 163: {
                this.assignAndSetFlags(this.aRef, this.indirectX().get());
                this.x = this.a;
                ++this.pc;
                break;
            }
            case 179: {
                this.cycles += this.evalPagecrossingIndirectY();
                this.assignAndSetFlags(this.aRef, this.indirectY().get());
                this.x = this.a;
                ++this.pc;
                break;
            }
            case 26: 
            case 58: 
            case 90: 
            case 122: 
            case 218: 
            case 250: {
                break;
            }
            case 4: 
            case 20: 
            case 52: 
            case 68: 
            case 84: 
            case 100: 
            case 116: 
            case 128: 
            case 130: 
            case 137: 
            case 194: 
            case 212: 
            case 226: 
            case 244: {
                ++this.pc;
                break;
            }
            case 12: 
            case 28: 
            case 60: 
            case 92: 
            case 124: 
            case 220: 
            case 252: {
                this.cycles += this.evalPagecrossingAbsoluteX();
                this.pc += 2;
                break;
            }
            case 105: {
                this.ADC(this.immediate());
                ++this.pc;
                break;
            }
            case 101: {
                this.ADC(this.zeropage());
                ++this.pc;
                break;
            }
            case 117: {
                this.ADC(this.zeropageX());
                ++this.pc;
                break;
            }
            case 109: {
                this.ADC(this.absolute());
                this.pc += 2;
                break;
            }
            case 125: {
                this.cycles += this.evalPagecrossingAbsoluteX();
                this.ADC(this.absoluteX());
                this.pc += 2;
                break;
            }
            case 121: {
                this.cycles += this.evalPagecrossingAbsoluteY();
                this.ADC(this.absoluteY());
                this.pc += 2;
                break;
            }
            case 97: {
                this.ADC(this.indirectX());
                ++this.pc;
                break;
            }
            case 113: {
                this.cycles += this.evalPagecrossingIndirectY();
                this.ADC(this.indirectY());
                ++this.pc;
                break;
            }
            case 41: {
                this.AND(this.immediate());
                ++this.pc;
                break;
            }
            case 37: {
                this.AND(this.zeropage());
                ++this.pc;
                break;
            }
            case 53: {
                this.AND(this.zeropageX());
                ++this.pc;
                break;
            }
            case 45: {
                this.AND(this.absolute());
                this.pc += 2;
                break;
            }
            case 61: {
                this.cycles += this.evalPagecrossingAbsoluteX();
                this.AND(this.absoluteX());
                this.pc += 2;
                break;
            }
            case 57: {
                this.cycles += this.evalPagecrossingAbsoluteY();
                this.AND(this.absoluteY());
                this.pc += 2;
                break;
            }
            case 33: {
                this.AND(this.indirectX());
                ++this.pc;
                break;
            }
            case 49: {
                this.cycles += this.evalPagecrossingIndirectY();
                this.AND(this.indirectY());
                ++this.pc;
                break;
            }
            case 10: {
                this.ASL(this.aRef);
                break;
            }
            case 6: {
                this.ASL(this.zeropage());
                ++this.pc;
                break;
            }
            case 22: {
                this.ASL(this.zeropageX());
                ++this.pc;
                break;
            }
            case 14: {
                this.ASL(this.absolute());
                this.pc += 2;
                break;
            }
            case 30: {
                this.ASL(this.absoluteX());
                this.pc += 2;
                break;
            }
            case 144: {
                if (!this.isSet(this.flags, 1)) {
                    this.branch();
                    break;
                }
                ++this.pc;
                break;
            }
            case 176: {
                if (this.isSet(this.flags, 1)) {
                    this.branch();
                    break;
                }
                ++this.pc;
                break;
            }
            case 240: {
                if (this.isSet(this.flags, 2)) {
                    this.branch();
                    break;
                }
                ++this.pc;
                break;
            }
            case 36: {
                this.BIT(this.zeropage());
                ++this.pc;
                break;
            }
            case 44: {
                this.BIT(this.absolute());
                this.pc += 2;
                break;
            }
            case 48: {
                if (this.isSet(this.flags, 128)) {
                    this.branch();
                    break;
                }
                ++this.pc;
                break;
            }
            case 208: {
                if (!this.isSet(this.flags, 2)) {
                    this.branch();
                    break;
                }
                ++this.pc;
                break;
            }
            case 16: {
                if (!this.isSet(this.flags, 128)) {
                    this.branch();
                    break;
                }
                ++this.pc;
                break;
            }
            case 80: {
                if (!this.isSet(this.flags, 64)) {
                    this.branch();
                    break;
                }
                ++this.pc;
                break;
            }
            case 112: {
                if (this.isSet(this.flags, 64)) {
                    this.branch();
                    break;
                }
                ++this.pc;
                break;
            }
            case 24: {
                this.flags &= 0xFFFFFFFE;
                break;
            }
            case 216: {
                this.flags &= 0xFFFFFFF7;
                break;
            }
            case 88: {
                this.flags &= 0xFFFFFFFB;
                break;
            }
            case 184: {
                this.flags &= 0xFFFFFFBF;
                break;
            }
            case 201: {
                this.CMP(this.aRef, this.immediate());
                ++this.pc;
                break;
            }
            case 197: {
                this.CMP(this.aRef, this.zeropage());
                ++this.pc;
                break;
            }
            case 213: {
                this.CMP(this.aRef, this.zeropageX());
                ++this.pc;
                break;
            }
            case 205: {
                this.CMP(this.aRef, this.absolute());
                this.pc += 2;
                break;
            }
            case 221: {
                this.cycles += this.evalPagecrossingAbsoluteX();
                this.CMP(this.aRef, this.absoluteX());
                this.pc += 2;
                break;
            }
            case 217: {
                this.cycles += this.evalPagecrossingAbsoluteY();
                this.CMP(this.aRef, this.absoluteY());
                this.pc += 2;
                break;
            }
            case 193: {
                this.CMP(this.aRef, this.indirectX());
                ++this.pc;
                break;
            }
            case 209: {
                this.cycles += this.evalPagecrossingIndirectY();
                this.CMP(this.aRef, this.indirectY());
                ++this.pc;
                break;
            }
            case 224: {
                this.CMP(this.xRef, this.immediate());
                ++this.pc;
                break;
            }
            case 228: {
                this.CMP(this.xRef, this.zeropage());
                ++this.pc;
                break;
            }
            case 236: {
                this.CMP(this.xRef, this.absolute());
                this.pc += 2;
                break;
            }
            case 192: {
                this.CMP(this.yRef, this.immediate());
                ++this.pc;
                break;
            }
            case 196: {
                this.CMP(this.yRef, this.zeropage());
                ++this.pc;
                break;
            }
            case 204: {
                this.CMP(this.yRef, this.absolute());
                this.pc += 2;
                break;
            }
            case 198: {
                this.DEC(this.zeropage());
                ++this.pc;
                break;
            }
            case 214: {
                this.DEC(this.zeropageX());
                ++this.pc;
                break;
            }
            case 206: {
                this.DEC(this.absolute());
                this.pc += 2;
                break;
            }
            case 222: {
                this.DEC(this.absoluteX());
                this.pc += 2;
                break;
            }
            case 202: {
                this.x = this.x - 1 & 0xFF;
                this.setFlags(this.x);
                break;
            }
            case 136: {
                this.y = this.y - 1 & 0xFF;
                this.setFlags(this.y);
                break;
            }
            case 73: {
                this.EOR(this.immediate());
                ++this.pc;
                break;
            }
            case 69: {
                this.EOR(this.zeropage());
                ++this.pc;
                break;
            }
            case 85: {
                this.EOR(this.zeropageX());
                ++this.pc;
                break;
            }
            case 77: {
                this.EOR(this.absolute());
                this.pc += 2;
                break;
            }
            case 93: {
                this.cycles += this.evalPagecrossingAbsoluteX();
                this.EOR(this.absoluteX());
                this.pc += 2;
                break;
            }
            case 89: {
                this.cycles += this.evalPagecrossingAbsoluteY();
                this.EOR(this.absoluteY());
                this.pc += 2;
                break;
            }
            case 65: {
                this.EOR(this.indirectX());
                ++this.pc;
                break;
            }
            case 81: {
                this.cycles += this.evalPagecrossingIndirectY();
                this.EOR(this.indirectY());
                ++this.pc;
                break;
            }
            case 230: {
                this.INC(this.zeropage());
                ++this.pc;
                break;
            }
            case 246: {
                this.INC(this.zeropageX());
                ++this.pc;
                break;
            }
            case 238: {
                this.INC(this.absolute());
                this.pc += 2;
                break;
            }
            case 254: {
                this.INC(this.absoluteX());
                this.pc += 2;
                break;
            }
            case 232: {
                this.x = this.x + 1 & 0xFF;
                this.setFlags(this.x);
                break;
            }
            case 200: {
                this.y = this.y + 1 & 0xFF;
                this.setFlags(this.y);
                break;
            }
            case 32: {
                this.push(this.pc + 1 >> 8);
                this.push(this.pc + 1 & 0xFF);
                this.pc = this.absolute().address;
                break;
            }
            case 76: {
                this.pc = this.absolute().address;
                break;
            }
            case 108: {
                int adr = this.absolute().address;
                this.pc = this.bus.read(adr) | this.bus.read(adr + 1 & 0xFF | adr & 0xFF00) << 8;
                break;
            }
            case 169: {
                this.assignAndSetFlags(this.aRef, this.immediate());
                ++this.pc;
                break;
            }
            case 165: {
                this.assignAndSetFlags(this.aRef, this.zeropage());
                ++this.pc;
                break;
            }
            case 181: {
                this.assignAndSetFlags(this.aRef, this.zeropageX());
                ++this.pc;
                break;
            }
            case 173: {
                this.assignAndSetFlags(this.aRef, this.absolute());
                this.pc += 2;
                break;
            }
            case 189: {
                this.cycles += this.evalPagecrossingAbsoluteX();
                this.assignAndSetFlags(this.aRef, this.absoluteX());
                this.pc += 2;
                break;
            }
            case 185: {
                this.cycles += this.evalPagecrossingAbsoluteY();
                this.assignAndSetFlags(this.aRef, this.absoluteY());
                this.pc += 2;
                break;
            }
            case 161: {
                this.assignAndSetFlags(this.aRef, this.indirectX());
                ++this.pc;
                break;
            }
            case 177: {
                this.cycles += this.evalPagecrossingIndirectY();
                this.assignAndSetFlags(this.aRef, this.indirectY());
                ++this.pc;
                break;
            }
            case 162: {
                this.assignAndSetFlags(this.xRef, this.immediate());
                ++this.pc;
                break;
            }
            case 166: {
                this.assignAndSetFlags(this.xRef, this.zeropage());
                ++this.pc;
                break;
            }
            case 182: {
                this.assignAndSetFlags(this.xRef, this.zeropageY());
                ++this.pc;
                break;
            }
            case 174: {
                this.assignAndSetFlags(this.xRef, this.absolute());
                this.pc += 2;
                break;
            }
            case 190: {
                this.cycles += this.evalPagecrossingAbsoluteY();
                this.assignAndSetFlags(this.xRef, this.absoluteY());
                this.pc += 2;
                break;
            }
            case 160: {
                this.assignAndSetFlags(this.yRef, this.immediate());
                ++this.pc;
                break;
            }
            case 164: {
                this.assignAndSetFlags(this.yRef, this.zeropage());
                ++this.pc;
                break;
            }
            case 180: {
                this.assignAndSetFlags(this.yRef, this.zeropageX());
                ++this.pc;
                break;
            }
            case 172: {
                this.assignAndSetFlags(this.yRef, this.absolute());
                this.pc += 2;
                break;
            }
            case 188: {
                this.cycles += this.evalPagecrossingAbsoluteX();
                this.assignAndSetFlags(this.yRef, this.absoluteX());
                this.pc += 2;
                break;
            }
            case 74: {
                this.LSR(this.aRef);
                break;
            }
            case 70: {
                this.LSR(this.zeropage());
                ++this.pc;
                break;
            }
            case 86: {
                this.LSR(this.zeropageX());
                ++this.pc;
                break;
            }
            case 78: {
                this.LSR(this.absolute());
                this.pc += 2;
                break;
            }
            case 94: {
                this.LSR(this.absoluteX());
                this.pc += 2;
                break;
            }
            case 234: {
                break;
            }
            case 9: {
                this.ORA(this.immediate());
                ++this.pc;
                break;
            }
            case 5: {
                this.ORA(this.zeropage());
                ++this.pc;
                break;
            }
            case 21: {
                this.ORA(this.zeropageX());
                ++this.pc;
                break;
            }
            case 13: {
                this.ORA(this.absolute());
                this.pc += 2;
                break;
            }
            case 29: {
                this.cycles += this.evalPagecrossingAbsoluteX();
                this.ORA(this.absoluteX());
                this.pc += 2;
                break;
            }
            case 25: {
                this.cycles += this.evalPagecrossingAbsoluteY();
                this.ORA(this.absoluteY());
                this.pc += 2;
                break;
            }
            case 1: {
                this.ORA(this.indirectX());
                ++this.pc;
                break;
            }
            case 17: {
                this.cycles += this.evalPagecrossingIndirectY();
                this.ORA(this.indirectY());
                ++this.pc;
                break;
            }
            case 72: {
                this.push(this.a);
                break;
            }
            case 8: {
                this.push(this.flags | 0x10 | 0x20);
                break;
            }
            case 104: {
                this.assignAndSetFlags(this.aRef, this.pop());
                break;
            }
            case 40: {
                this.flags = this.pop();
                break;
            }
            case 42: {
                this.ROL(this.aRef);
                break;
            }
            case 38: {
                this.ROL(this.zeropage());
                ++this.pc;
                break;
            }
            case 54: {
                this.ROL(this.zeropageX());
                ++this.pc;
                break;
            }
            case 46: {
                this.ROL(this.absolute());
                this.pc += 2;
                break;
            }
            case 62: {
                this.ROL(this.absoluteX());
                this.pc += 2;
                break;
            }
            case 106: {
                this.ROR(this.aRef);
                break;
            }
            case 102: {
                this.ROR(this.zeropage());
                ++this.pc;
                break;
            }
            case 118: {
                this.ROR(this.zeropageX());
                ++this.pc;
                break;
            }
            case 110: {
                this.ROR(this.absolute());
                this.pc += 2;
                break;
            }
            case 126: {
                this.ROR(this.absoluteX());
                this.pc += 2;
                break;
            }
            case 64: {
                this.flags = this.pop();
                this.pc = this.pop();
                this.pc |= this.pop() << 8;
                break;
            }
            case 96: {
                this.pc = this.pop();
                this.pc |= this.pop() << 8;
                ++this.pc;
                break;
            }
            case 233: {
                this.SBC(this.immediate());
                ++this.pc;
                break;
            }
            case 229: {
                this.SBC(this.zeropage());
                ++this.pc;
                break;
            }
            case 245: {
                this.SBC(this.zeropageX());
                ++this.pc;
                break;
            }
            case 237: {
                this.SBC(this.absolute());
                this.pc += 2;
                break;
            }
            case 253: {
                this.cycles += this.evalPagecrossingAbsoluteX();
                this.SBC(this.absoluteX());
                this.pc += 2;
                break;
            }
            case 249: {
                this.cycles += this.evalPagecrossingAbsoluteY();
                this.SBC(this.absoluteY());
                this.pc += 2;
                break;
            }
            case 225: {
                this.SBC(this.indirectX());
                ++this.pc;
                break;
            }
            case 241: {
                this.cycles += this.evalPagecrossingIndirectY();
                this.SBC(this.indirectY());
                ++this.pc;
                break;
            }
            case 56: {
                this.flags |= 1;
                break;
            }
            case 248: {
                this.flags |= 8;
                break;
            }
            case 120: {
                this.flags |= 4;
                break;
            }
            case 133: {
                this.zeropage().set(this.a);
                ++this.pc;
                break;
            }
            case 149: {
                this.zeropageX().set(this.a);
                ++this.pc;
                break;
            }
            case 141: {
                this.absolute().set(this.a);
                this.pc += 2;
                break;
            }
            case 157: {
                this.absoluteX().set(this.a);
                this.pc += 2;
                break;
            }
            case 153: {
                this.absoluteY().set(this.a);
                this.pc += 2;
                break;
            }
            case 129: {
                this.indirectX().set(this.a);
                ++this.pc;
                break;
            }
            case 145: {
                this.indirectY().set(this.a);
                ++this.pc;
                break;
            }
            case 134: {
                this.zeropage().set(this.x);
                ++this.pc;
                break;
            }
            case 150: {
                this.zeropageY().set(this.x);
                ++this.pc;
                break;
            }
            case 142: {
                this.absolute().set(this.x);
                this.pc += 2;
                break;
            }
            case 132: {
                this.zeropage().set(this.y);
                ++this.pc;
                break;
            }
            case 148: {
                this.zeropageX().set(this.y);
                ++this.pc;
                break;
            }
            case 140: {
                this.absolute().set(this.y);
                this.pc += 2;
                break;
            }
            case 170: {
                this.assignAndSetFlags(this.xRef, this.a);
                break;
            }
            case 186: {
                this.assignAndSetFlags(this.xRef, this.sp);
                break;
            }
            case 138: {
                this.assignAndSetFlags(this.aRef, this.x);
                break;
            }
            case 154: {
                this.spRef.set(this.x);
                break;
            }
            case 152: {
                this.assignAndSetFlags(this.aRef, this.y);
                break;
            }
            case 168: {
                this.assignAndSetFlags(this.yRef, this.a);
                break;
            }
            case 0: {
                this.brk();
                break;
            }
            default: {
                return RunState.UNIMPLEMENTED_OPCODE;
            }
        }
        return RunState.RUNNING;
    }

    private void assertValidByteRange(int b) {
        if (b > 255) {
            throw new AssertionError();
        }
        if (b < 0) {
            throw new AssertionError();
        }
    }

    public void reset() {
        this.interruptSequence(65532, false, false);
    }

    public void nmi() {
        this.interruptSequence(65530, true, false);
    }

    public void irq() {
        this.interruptSequence(65534, true, false);
    }

    public void brk() {
        this.interruptSequence(65534, true, true);
    }

    private void interruptSequence(int vectorAddress, boolean pushPcAndP, boolean setBreakFlag) {
        if (pushPcAndP) {
            int returnAddress = this.pc + 1;
            this.push(returnAddress >> 8);
            this.push(returnAddress & 0xFF);
            int flagsToPush = this.flags | 0x20;
            if (setBreakFlag) {
                this.push(flagsToPush | 0x10);
            } else {
                this.push(flagsToPush & 0xFFFFFFEF);
            }
        }
        this.flags |= 4;
        this.pc = this.bus.readWord(vectorAddress);
    }

    private class Pointer
    implements Ref {
        private final int address;

        Pointer(int address) {
            this.address = address;
        }

        @Override
        public int get() {
            return Mpu6502.this.bus.read(this.address);
        }

        @Override
        public void set(int value) {
            Mpu6502.this.bus.write(this.address, value);
        }

        public String toString() {
            return String.format("mem[%04x] (= %02x)", this.address, Mpu6502.this.bus.read(this.address));
        }
    }

    private static interface Ref {
        public int get();

        public void set(int var1);
    }
}

