/*
 * Decompiled with CFR 0.152.
 */
package com.laamella.mpu6502;

import com.laamella.mpu6502.Bus;
import com.laamella.mpu6502.Segment;

public class OnlyMemoryBus
implements Bus {
    private final int[] memory;

    public OnlyMemoryBus(int[] memory) {
        this.memory = memory;
    }

    public OnlyMemoryBus(byte[] memory) {
        this.memory = new int[memory.length];
        for (int i = 0; i < memory.length; ++i) {
            this.memory[i] = memory[i] & 0xFF;
        }
    }

    public OnlyMemoryBus() {
        this.memory = new int[65536];
    }

    @Override
    public int read(int address) {
        return this.memory[address];
    }

    @Override
    public void write(int address, int data) {
        if (data > 255 || data < 0) {
            throw new IllegalStateException();
        }
        this.memory[address] = data;
    }

    @Override
    public int peek(int address) {
        return this.memory[address];
    }

    public void load(Segment segment) {
        System.arraycopy(segment.data, 0, this.memory, segment.loadAddress, segment.data.length);
    }
}

