/*
 * Decompiled with CFR 0.152.
 */
package com.laamella.mpu6502.assembler;

import com.laamella.mpu6502.Segment;
import com.laamella.mpu6502.assembler.Line;
import com.laamella.mpu6502.assembler.Org;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Assembler {
    private final List<Line> lines = new ArrayList<Line>();

    private void resolveAddresses() {
        Integer pc = null;
        for (Line line : this.lines) {
            if (line instanceof Org) {
                pc = line.address;
                continue;
            }
            if (pc == null) {
                throw new IllegalStateException("Cannot assemble without an org(...).");
            }
            line.address = pc;
            pc = pc + line.byteSize();
        }
    }

    public void add(Line ... lines) {
        this.lines.addAll(Arrays.asList(lines));
    }

    public void add(Line line) {
        this.lines.add(line);
    }

    public List<Segment> assemble() {
        this.resolveAddresses();
        return this.generateMachineCode();
    }

    private List<Segment> generateMachineCode() {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int loadAddress = 0;
        ArrayList data = null;
        for (Line line : this.lines) {
            if (line instanceof Org) {
                if (data != null) {
                    segments.add(new Segment(loadAddress, data));
                }
                loadAddress = line.address;
                data = new ArrayList();
            }
            line.assembleTo(data::add);
        }
        if (data != null) {
            segments.add(new Segment(loadAddress, data));
        }
        return segments;
    }

    public String toString() {
        return this.lines.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }
}

