/*
 * Decompiled with CFR 0.152.
 */
package com.laamella.mpu6502.assembler;

import com.laamella.mpu6502.assembler.Line;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Bytes
extends Line {
    private final int[] bytes;

    Bytes(int ... bytes) {
        this.bytes = bytes;
    }

    @Override
    public int byteSize() {
        return this.bytes.length;
    }

    @Override
    public void assembleTo(Consumer<Integer> data) {
        for (int b : this.bytes) {
            data.accept(b);
        }
    }

    public String toString() {
        return this.getAddress().map(Object::toString).orElse("?") + "\t.byte " + Arrays.stream(this.bytes).mapToObj(b -> "" + b).collect(Collectors.joining());
    }
}

