/*
 * Decompiled with CFR 0.152.
 */
package com.laamella.mpu6502.assembler;

import com.laamella.mpu6502.Mpu6502Specifications;
import com.laamella.mpu6502.assembler.Line;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class Instruction
extends Line {
    private final int opcode;
    private final Supplier<Optional<Integer>> operand;

    Instruction(int opcode, Supplier<Optional<Integer>> operand) {
        this.opcode = opcode;
        this.operand = operand;
    }

    @Override
    public int byteSize() {
        return Mpu6502Specifications.ADDRESSING_MODE[this.opcode].totalBytes;
    }

    @Override
    public void assembleTo(Consumer<Integer> data) {
        data.accept(this.opcode);
        if (this.byteSize() > 1) {
            int oper = this.operand.get().get();
            data.accept(oper & 0xFF);
            if (this.byteSize() > 2) {
                data.accept(oper >> 8 & 0xFF);
            }
        }
    }

    public String toString() {
        if (this.byteSize() == 1) {
            return this.getAddress().orElse(0) + "\t" + Mpu6502Specifications.OPCODE_NAME[this.opcode];
        }
        return this.getAddress().orElse(0) + "\t" + Mpu6502Specifications.OPCODE_NAME[this.opcode] + " " + this.operand.get().map(Object::toString).orElse("?");
    }
}

