/*
 * Decompiled with CFR 0.152.
 */
package com.laamella.mpu6502.disassembler;

import com.laamella.mpu6502.Mpu6502Specifications;

public class Disassembler {
    private int toSignedByte(int data) {
        if ((data & 0x80) > 0) {
            return (data & 0x7F) - 128;
        }
        return data & 0x7F;
    }

    public String disassembleAsm(int opcode, int byte1, int byte2, int addr) {
        String operand;
        String name = Mpu6502Specifications.OPCODE_NAME[opcode];
        Mpu6502Specifications.AddressingMode addressingMode = Mpu6502Specifications.ADDRESSING_MODE[opcode];
        switch (addressingMode) {
            case IZX: {
                operand = String.format("($%02X, X)", byte1);
                break;
            }
            case IZY: {
                operand = String.format("($%02X), Y", byte1);
                break;
            }
            case REL: {
                operand = String.format("$%04X", addr + this.toSignedByte(byte1) + 2);
                break;
            }
            case IND: {
                operand = String.format("($%02X%02X)", byte2, byte1);
                break;
            }
            case ABS: {
                operand = String.format("$%02X%02X", byte2, byte1);
                break;
            }
            case ABX: {
                operand = String.format("$%02X%02X, X", byte2, byte1);
                break;
            }
            case ABY: {
                operand = String.format("$%02X%02X, Y", byte2, byte1);
                break;
            }
            case IMM: {
                operand = String.format("#%02X", byte1);
                break;
            }
            case ZP: {
                operand = String.format("$%02X", byte1);
                break;
            }
            case ZPX: {
                operand = String.format("$%02X, X", byte1);
                break;
            }
            case ZPY: {
                operand = String.format("$%02X, Y", byte1);
                break;
            }
            case JAM: 
            case NONE: {
                operand = "";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return name + " " + operand;
    }

    public String disassembleBytes(int opcode, int byte1, int byte2) {
        switch (Mpu6502Specifications.ADDRESSING_MODE[opcode].totalBytes) {
            case 1: {
                return String.format("%02X", opcode);
            }
            case 2: {
                return String.format("%02X %02X", opcode, byte1);
            }
            case 3: {
                return String.format("%02X %02X %02X", opcode, byte1, byte2);
            }
        }
        throw new IllegalStateException();
    }
}

