/*
 * Decompiled with CFR 0.152.
 */
package com.laamella.mpu6502.monitor;

import com.laamella.mpu6502.Mpu6502;
import com.laamella.mpu6502.RunState;
import com.laamella.mpu6502.disassembler.Disassembler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class Monitor {
    public final Mpu6502 mpu;
    private final List<Predicate<Mpu6502>> breakpoints = new ArrayList<Predicate<Mpu6502>>();
    private final Disassembler disassembler = new Disassembler();

    public Monitor(Mpu6502 mpu) {
        this.mpu = mpu;
    }

    private boolean isSet(int val, int mask) {
        return (val & mask) > 0;
    }

    public void run() {
        block0: while (true) {
            Predicate<Mpu6502> breakpoint;
            if (this.mpu.step() != RunState.RUNNING) {
                return;
            }
            Iterator<Predicate<Mpu6502>> iterator = this.breakpoints.iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (!(breakpoint = iterator.next()).test(this.mpu));
            break;
        }
    }

    public Predicate<Mpu6502> addBreakpoint(Predicate<Mpu6502> breakpoint) {
        this.breakpoints.add(breakpoint);
        return breakpoint;
    }

    public void removeBreakpoint(Predicate<Mpu6502> breakpoint) {
        this.breakpoints.remove(breakpoint);
    }

    public Predicate<Mpu6502> addProgramCounterBreakpoint(int breakAddress) {
        return this.addBreakpoint(mpu -> mpu.pc == breakAddress);
    }

    public Predicate<Mpu6502> addMemoryValueBreakpoint(int address, int breakValue) {
        return this.addBreakpoint(mpu -> mpu.bus.peek(address) == breakValue);
    }

    public String toString() {
        return String.format("%04X %-12s %-14s - A:%02X X:%02X Y:%02X SP:%02X %s    %d", this.mpu.pc, this.disassembler.disassembleBytes(this.mpu.bus.peek(this.mpu.pc), this.mpu.bus.peek(this.mpu.pc + 1), this.mpu.bus.peek(this.mpu.pc + 2)), this.disassembler.disassembleAsm(this.mpu.bus.peek(this.mpu.pc), this.mpu.bus.peek(this.mpu.pc + 1), this.mpu.bus.peek(this.mpu.pc + 2), this.mpu.pc), this.mpu.a, this.mpu.x, this.mpu.y, this.mpu.sp, this.getFlagsString(), this.mpu.cycles);
    }

    private String getFlagsString() {
        return (this.isSet(this.mpu.flags, 128) ? "N" : ".") + (this.isSet(this.mpu.flags, 64) ? "V" : ".") + (this.isSet(this.mpu.flags, 32) ? "1" : ".") + (this.isSet(this.mpu.flags, 16) ? "B" : ".") + (this.isSet(this.mpu.flags, 8) ? "D" : ".") + (this.isSet(this.mpu.flags, 4) ? "I" : ".") + (this.isSet(this.mpu.flags, 2) ? "Z" : ".") + (this.isSet(this.mpu.flags, 1) ? "C" : ".");
    }
}

