/*
 * Decompiled with CFR 0.152.
 */
package com.labun.buildnumber;

import com.labun.buildnumber.Logger;
import com.labun.buildnumber.Parameters;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.errors.RevWalkException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class BuildNumberExtractor {
    static final List<String> propertyNames = Arrays.asList("revision", "shortRevision", "dirty", "branch", "tag", "nearestTag", "parent", "shortParent", "commitsCount", "commitsCountSinceNearestTag", "authorDate", "commitDate", "describe", "buildDateMillis", "buildDate", "buildNumber");
    private static final String EMPTY_STRING = "";
    final long startTime = System.currentTimeMillis();
    Parameters params;
    Logger logger;
    Future<ScriptEngine> jsEngineFuture;
    File gitDir;
    Git git;
    Repository repo;
    ObjectId headObjectId;
    private String headSha1;
    private boolean gitStatusDirty;
    private TagInfo nearestTagInfo;

    void log(String msg) {
        this.logger.log(msg);
    }

    void logVerbose(String msg) {
        if (this.params.getVerbose().booleanValue()) {
            this.logger.log(msg);
        }
    }

    public BuildNumberExtractor(Parameters params, Logger logger) throws Exception {
        this.params = params;
        this.logger = logger;
        long t = System.currentTimeMillis();
        params.validateAndSetParameterValues();
        this.logVerbose("params: " + params.asString());
        this.logVerbose("java: " + System.getProperty("java.version"));
        this.jsEngineFuture = params.getBuildNumberFormat() != null ? CompletableFuture.supplyAsync(() -> this.getJsEngine()) : null;
        File repoDirectory = params.getRepositoryDirectory();
        if (!repoDirectory.exists() || !repoDirectory.isDirectory()) {
            throw new IOException("Invalid repository directory provided: " + repoDirectory.getAbsolutePath());
        }
        File canonicalRepo = repoDirectory.getCanonicalFile();
        RepositoryBuilder builder = (RepositoryBuilder)new RepositoryBuilder().findGitDir(canonicalRepo);
        this.gitDir = builder.getGitDir();
        this.logVerbose("gitDir=" + this.gitDir);
        if (this.gitDir == null) {
            throw new IllegalArgumentException("Git directory '.git' not found (check parameter 'repositoryDirectory')");
        }
        this.git = Git.open((File)this.gitDir);
        this.repo = this.git.getRepository();
        Ref headRef = this.repo.exactRef("HEAD");
        if (headRef == null) {
            throw new IllegalArgumentException("Cannot read current revision (HEAD) from repository: " + this.repo);
        }
        this.headObjectId = headRef.getObjectId();
        if (this.headObjectId == null) {
            throw new IllegalArgumentException("Git repository is empty (perhaps just initialized with `git init`): " + this.repo);
        }
        this.headSha1 = this.headObjectId.name();
        Status gitStatus = this.git.status().call();
        this.gitStatusDirty = !gitStatus.isClean();
        this.logVerbose("repo state: headSha1=" + this.headSha1 + ", gitStatusDirty=" + this.gitStatusDirty);
        if (this.gitStatusDirty) {
            this.logVerbose("gitStatusDirty caused by:\n    added:             " + gitStatus.getAdded() + ",\n    changed:           " + gitStatus.getChanged() + ",\n    removed:           " + gitStatus.getRemoved() + ",\n    missing:           " + gitStatus.getMissing() + ",\n    modified:          " + gitStatus.getModified() + ",\n    conflicting:       " + gitStatus.getConflicting() + ",\n    untracked (files): " + gitStatus.getUntracked() + "\nadditional info (not impacting dirty status):\n    untracked folders: " + gitStatus.getUntrackedFolders() + ",\n    ignoredNotInIndex: " + gitStatus.getIgnoredNotInIndex());
        }
        this.logVerbose("initializing Git repo, get base data: " + (System.currentTimeMillis() - t) + " ms");
    }

    protected void finalize() throws Throwable {
        this.git.close();
    }

    public Map<String, String> extract() throws Exception {
        long t = System.currentTimeMillis();
        try (PlotWalk revWalk = new PlotWalk(this.repo);){
            String branch = this.readCurrentBranch(this.headSha1);
            Map<String, SortedSet<String>> tagMap = this.loadTagsMap();
            String tag = this.readTag(tagMap, this.headSha1);
            RevCommit headCommit = revWalk.parseCommit((AnyObjectId)this.headObjectId);
            String parent = BuildNumberExtractor.readParent(headCommit);
            String shortParent = BuildNumberExtractor.readShortParent(headCommit, this.params.getShortRevisionLength());
            SimpleDateFormat dfGitDate = new SimpleDateFormat(this.params.getGitDateFormat());
            if (this.params.getDateFormatTimeZone() != null) {
                dfGitDate.setTimeZone(TimeZone.getTimeZone(this.params.getDateFormatTimeZone()));
            }
            String authorDate = dfGitDate.format(headCommit.getAuthorIdent().getWhen());
            String commitDate = dfGitDate.format(headCommit.getCommitterIdent().getWhen());
            int commitsCount = this.countCommits((RevWalk)revWalk, tagMap, headCommit, this.params.getCountCommitsSinceInclusive(), this.params.getCountCommitsSinceExclusive(), this.params.getCountCommitsInPath());
            String nearestTag = this.nearestTagInfo == null ? EMPTY_STRING : String.join((CharSequence)";", this.nearestTagInfo.tagNames);
            String commitsCountSinceNearestTag = this.nearestTagInfo == null ? EMPTY_STRING : EMPTY_STRING + this.nearestTagInfo.commitsCountSince;
            String describe = BuildNumberExtractor.readDescribe(this.git);
            String buildDateMillis = EMPTY_STRING + this.startTime;
            SimpleDateFormat dfBuildDate = new SimpleDateFormat(this.params.getBuildDateFormat());
            if (this.params.getDateFormatTimeZone() != null) {
                dfBuildDate.setTimeZone(TimeZone.getTimeZone(this.params.getDateFormatTimeZone()));
            }
            String buildDate = dfBuildDate.format(new Date(this.startTime));
            String revision = this.headSha1;
            String shortRevision = BuildNumberExtractor.abbreviateSha1(this.headSha1, this.params.getShortRevisionLength());
            String dirty = this.gitStatusDirty ? this.params.getDirtyValue() : EMPTY_STRING;
            String commitsCountAsString = Integer.toString(commitsCount);
            String buildNumber = this.defaultBuildNumber(tag, branch, commitsCountAsString, shortRevision, dirty);
            TreeMap<String, String> res = new TreeMap<String, String>();
            res.put("revision", revision);
            res.put("shortRevision", shortRevision);
            res.put("dirty", dirty);
            res.put("branch", branch);
            res.put("tag", tag);
            res.put("nearestTag", nearestTag);
            res.put("parent", parent);
            res.put("shortParent", shortParent);
            res.put("commitsCount", commitsCountAsString);
            res.put("commitsCountSinceNearestTag", commitsCountSinceNearestTag);
            res.put("authorDate", authorDate);
            res.put("commitDate", commitDate);
            res.put("describe", describe);
            res.put("buildDateMillis", buildDateMillis);
            res.put("buildDate", buildDate);
            res.put("buildNumber", buildNumber);
            this.logVerbose("extracting properties for buildNumber: " + (System.currentTimeMillis() - t) + " ms");
            t = System.currentTimeMillis();
            if (this.params.getBuildNumberFormat() != null) {
                ScriptEngine jsEngine = this.jsEngineFuture.get();
                this.logVerbose("waiting for initialization of JS engine: " + (System.currentTimeMillis() - t) + " ms");
                t = System.currentTimeMillis();
                String jsBuildNumber = this.formatBuildNumberWithJS(jsEngine, res);
                res.put("buildNumber", jsBuildNumber);
                this.logVerbose("formatting buildNumber with JS: " + (System.currentTimeMillis() - t) + " ms");
            }
            this.logVerbose("all extracted properties: " + res);
            this.log("BUILDNUMBER: " + (String)res.get("buildNumber"));
            for (String property : propertyNames) {
                if (res.get(property) != null) continue;
                throw new RuntimeException("Property '" + property + "' is not set");
            }
            TreeMap<String, String> treeMap = res;
            return treeMap;
        }
    }

    private static String abbreviateSha1(String sha1, int length) {
        return sha1 != null && sha1.length() > length ? sha1.substring(0, length) : sha1;
    }

    public String defaultBuildNumber(String tag, String branch, String commitsCount, String shortRevision, String dirty) {
        String name = tag.length() > 0 ? tag : (branch.length() > 0 ? branch : "UNNAMED");
        return name + "." + commitsCount + "." + shortRevision + (dirty.length() > 0 ? "-" + dirty : EMPTY_STRING);
    }

    private String readCurrentBranch(String headSha1) throws IOException {
        String branch = this.repo.getBranch();
        if (null == branch) {
            return EMPTY_STRING;
        }
        if (headSha1.equals(branch)) {
            return EMPTY_STRING;
        }
        return branch;
    }

    private String readTag(Map<String, SortedSet<String>> tagMap, String sha1) {
        SortedSet<String> tags = tagMap.get(sha1);
        if (tags == null) {
            return EMPTY_STRING;
        }
        return String.join((CharSequence)";", tags);
    }

    private static String readParent(RevCommit commit) {
        if (commit == null) {
            return EMPTY_STRING;
        }
        RevCommit[] parents = commit.getParents();
        if (parents == null || parents.length == 0) {
            return EMPTY_STRING;
        }
        return Stream.of(parents).map(p -> p.getId().name()).collect(Collectors.joining(";"));
    }

    private static String readShortParent(RevCommit commit, int length) {
        if (commit == null) {
            return EMPTY_STRING;
        }
        RevCommit[] parents = commit.getParents();
        if (parents == null || parents.length == 0) {
            return EMPTY_STRING;
        }
        return Stream.of(parents).map(p -> BuildNumberExtractor.abbreviateSha1(p.getId().name(), length)).collect(Collectors.joining(";"));
    }

    private static String readDescribe(Git git) throws Exception {
        String describe = git.describe().setLong(true).setTags(true).setAlways(true).call();
        return describe != null ? describe : EMPTY_STRING;
    }

    private Map<String, SortedSet<String>> loadTagsMap() {
        Map refMap = this.repo.getTags();
        this.logVerbose("number of tags: " + refMap.size());
        HashMap<String, SortedSet<String>> res = new HashMap<String, SortedSet<String>>(refMap.size());
        for (Map.Entry entry : refMap.entrySet()) {
            String sha1 = this.extractPeeledSha1((Ref)entry.getValue());
            res.computeIfAbsent(sha1, k -> new TreeSet()).add(entry.getKey());
        }
        return res;
    }

    private String extractPeeledSha1(Ref tagRef) {
        Ref peeled = this.repo.peel(tagRef);
        if (peeled.getPeeledObjectId() != null) {
            return peeled.getPeeledObjectId().name();
        }
        return peeled.getObjectId().name();
    }

    private int countCommits(RevWalk walk, Map<String, SortedSet<String>> tagMap, RevCommit headCommit, String countCommitsSinceInclusive, String countCommitsSinceExclusive, String countCommitsInPath) throws Exception {
        this.nearestTagInfo = null;
        try {
            if (countCommitsInPath != null) {
                walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)countCommitsInPath), (TreeFilter)TreeFilter.ANY_DIFF));
            }
            walk.setRetainBody(false);
            walk.markStart(headCommit);
            int res = 0;
            if (countCommitsSinceInclusive != null) {
                String ancestorSha1 = this.getSha1(countCommitsSinceInclusive);
                for (RevCommit commit : walk) {
                    String sha1 = commit.getId().getName();
                    if (this.nearestTagInfo == null) {
                        this.nearestTagInfo = this.tryExtractTagInfo(tagMap, sha1, res);
                    }
                    ++res;
                    if (!sha1.startsWith(ancestorSha1)) continue;
                    return res;
                }
                this.logAndThrow("commit '" + countCommitsSinceInclusive + "' not found (parameter 'countCommitsSinceInclusive')", countCommitsInPath);
            } else if (countCommitsSinceExclusive != null) {
                String ancestorSha1 = this.getSha1(countCommitsSinceExclusive);
                for (RevCommit commit : walk) {
                    String sha1 = commit.getId().getName();
                    if (this.nearestTagInfo == null) {
                        this.nearestTagInfo = this.tryExtractTagInfo(tagMap, sha1, res);
                    }
                    if (sha1.startsWith(ancestorSha1)) {
                        return res;
                    }
                    ++res;
                }
                this.logAndThrow("commit '" + countCommitsSinceExclusive + "' not found (parameter 'countCommitsSinceExclusive')", countCommitsInPath);
            } else {
                for (RevCommit commit : walk) {
                    String sha1 = commit.getId().getName();
                    if (this.nearestTagInfo == null) {
                        this.nearestTagInfo = this.tryExtractTagInfo(tagMap, sha1, res);
                    }
                    ++res;
                }
            }
            return res;
        }
        catch (RevWalkException ex) {
            return -1;
        }
    }

    private TagInfo tryExtractTagInfo(Map<String, SortedSet<String>> tagMap, String sha1, int commitNo) {
        SortedSet<String> tagNames = tagMap.get(sha1);
        return tagNames != null ? new TagInfo(tagNames, commitNo) : null;
    }

    private void logAndThrow(String errorMessage, String countCommitsInPathParameter) {
        this.log(errorMessage);
        if (countCommitsInPathParameter != null) {
            this.log("note: only commits which affecting the path " + countCommitsInPathParameter + " are considered (parameter 'countCommitsInPath')");
            this.log("note: merge commits are usually not affecting any paths");
        }
        throw new IllegalArgumentException(errorMessage);
    }

    private String getSha1(String tagOrSha1) throws Exception {
        Ref ref = this.repo.exactRef("refs/tags/" + tagOrSha1);
        if (ref == null) {
            return tagOrSha1;
        }
        return this.extractPeeledSha1(ref);
    }

    private String formatBuildNumberWithJS(ScriptEngine jsEngine, Map<String, String> gitProperties) throws Exception {
        if (jsEngine == null) {
            throw new IllegalStateException("JS engine is null");
        }
        for (Map.Entry<String, String> e : gitProperties.entrySet()) {
            jsEngine.put(e.getKey(), e.getValue());
        }
        jsEngine.put("env", System.getenv());
        Object res = jsEngine.eval(this.params.getBuildNumberFormat());
        if (res == null) {
            throw new IllegalStateException("JS buildNumber is null");
        }
        return res.toString();
    }

    private ScriptEngine getJsEngine() {
        ScriptEngineFactory factory;
        long time = System.currentTimeMillis();
        String javaVersion = System.getProperty("java.version");
        try {
            if (javaVersion.startsWith("1.8") || javaVersion.startsWith("9") || javaVersion.startsWith("10")) {
                this.logVerbose("using built-in Nashorn JavaScript engine from JDK (running on Java 8 .. 10)");
                factory = (ScriptEngineFactory)Class.forName("jdk.nashorn.api.scripting.NashornScriptEngineFactory").newInstance();
            } else {
                this.logVerbose("using standalone Nashorn JavaScript engine (running on Java 11+)");
                factory = (ScriptEngineFactory)Class.forName("org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory").newInstance();
            }
        }
        catch (Exception e) {
            this.log("cannot load NashornScriptEngineFactory: " + e);
            return null;
        }
        this.logVerbose("[parallel thread] loading JS factory: " + (System.currentTimeMillis() - time) + " ms");
        time = System.currentTimeMillis();
        ScriptEngine jsEngine = factory.getScriptEngine();
        if (jsEngine == null) {
            this.log("Nashorn JavaScript engine not found!");
        }
        this.logVerbose("[parallel thread] loading JS Engine: " + (System.currentTimeMillis() - time) + " ms");
        time = System.currentTimeMillis();
        return jsEngine;
    }

    public String getHeadSha1() {
        return this.headSha1;
    }

    public boolean isGitStatusDirty() {
        return this.gitStatusDirty;
    }

    static class TagInfo {
        private final SortedSet<String> tagNames;
        private final int commitsCountSince;

        public TagInfo(SortedSet<String> tagNames, int commitsCountSince) {
            this.tagNames = tagNames;
            this.commitsCountSince = commitsCountSince;
        }

        public SortedSet<String> getTagNames() {
            return this.tagNames;
        }

        public int getCommitsCountSince() {
            return this.commitsCountSince;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TagInfo)) {
                return false;
            }
            TagInfo other = (TagInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCommitsCountSince() != other.getCommitsCountSince()) {
                return false;
            }
            SortedSet<String> this$tagNames = this.getTagNames();
            SortedSet<String> other$tagNames = other.getTagNames();
            return !(this$tagNames == null ? other$tagNames != null : !this$tagNames.equals(other$tagNames));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TagInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCommitsCountSince();
            SortedSet<String> $tagNames = this.getTagNames();
            result = result * 59 + ($tagNames == null ? 43 : $tagNames.hashCode());
            return result;
        }

        public String toString() {
            return "BuildNumberExtractor.TagInfo(tagNames=" + this.getTagNames() + ", commitsCountSince=" + this.getCommitsCountSince() + ")";
        }
    }
}

