/*
 * Decompiled with CFR 0.152.
 */
package com.labun.buildnumber;

import com.labun.buildnumber.BuildNumberExtractor;
import com.labun.buildnumber.Logger;
import com.labun.buildnumber.Parameters;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="extract-buildnumber", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class JGitBuildNumberMojo
extends AbstractMojo
implements Parameters {
    @Component
    private BuildContext buildContext;
    @Parameter
    private String namespace;
    @Parameter
    private String dirtyValue;
    @Parameter
    private Integer shortRevisionLength;
    @Parameter
    private String gitDateFormat;
    @Parameter
    private String buildDateFormat;
    @Parameter
    private String dateFormatTimeZone;
    @Parameter
    private String countCommitsSinceInclusive;
    @Parameter
    private String countCommitsSinceExclusive;
    @Parameter
    private String countCommitsInPath;
    @Parameter
    private String buildNumberFormat;
    @Parameter
    private File repositoryDirectory;
    @Parameter
    private Boolean runOnlyAtExecutionRoot;
    @Parameter
    private Boolean skip;
    @Parameter
    private Boolean verbose;
    @Parameter(property="project.basedir", readonly=true, required=true)
    private File baseDirectory;
    @Parameter(property="session.executionRootDirectory", readonly=true, required=true)
    private File executionRootDirectory;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="project.parent", readonly=true)
    private MavenProject parentProject;

    /*
     * Unable to fully structure code
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block17: {
            block18: {
                start = System.currentTimeMillis();
                if (this.getRepositoryDirectory() == null) {
                    this.setRepositoryDirectory(this.project.getBasedir());
                }
                this.validateAndSetParameterValues();
                if (this.skip.booleanValue()) {
                    this.getLog().info((CharSequence)"Execution is skipped by configuration.");
                    return;
                }
                if (this.verbose.booleanValue()) {
                    this.getLog().info((CharSequence)"JGit BuildNumber Maven Plugin - start");
                }
                if (this.verbose.booleanValue()) {
                    this.getLog().info((CharSequence)("executionRootDirectory: " + this.executionRootDirectory + ", baseDirectory: " + this.baseDirectory));
                }
                if (!this.runOnlyAtExecutionRoot.booleanValue() || this.executionRootDirectory.equals(this.baseDirectory)) {
                    extractor = new BuildNumberExtractor((Parameters)this, (Logger)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)V, lambda$execute$0(java.lang.String ), (Ljava/lang/String;)V)((JGitBuildNumberMojo)this));
                    headSha1 = extractor.getHeadSha1();
                    dirty = extractor.isGitStatusDirty() != false ? this.dirtyValue : null;
                    params = Arrays.asList(new Object[]{headSha1, dirty, this.shortRevisionLength, this.gitDateFormat, this.buildDateFormat, this.dateFormatTimeZone, this.countCommitsSinceInclusive, this.countCommitsSinceExclusive, this.countCommitsInPath, this.buildNumberFormat});
                    paramsKey = "jgitParams" + this.namespace;
                    result = this.getCachedResultFromBuildConext(paramsKey, params, resultKey = "jgitResult" + this.namespace);
                    if (result != null) {
                        if (this.verbose.booleanValue()) {
                            this.getLog().info((CharSequence)("using cached result: " + result));
                        }
                    } else {
                        result = extractor.extract();
                        this.saveResultToBuildContext(paramsKey, params, resultKey, result);
                    }
                    this.setProperties(result, this.project.getProperties());
                    break block17;
                }
                if (!"pom".equals(this.parentProject.getPackaging())) ** GOTO lbl44
                parentProps = this.parentProject.getProperties();
                revision = parentProps.getProperty(this.namespace + ".revision");
                if (revision != null) break block18;
                this.getLog().warn((CharSequence)"Cannot extract Git info, maybe custom build with 'pl' argument is running");
                this.fillPropsUnknown();
                duration = System.currentTimeMillis() - start;
                if (this.verbose.booleanValue()) {
                    this.getLog().info((CharSequence)String.format("JGit BuildNumber Maven Plugin - end (execution time: %d ms)", new Object[]{duration}));
                }
                return;
            }
            try {
                if (this.verbose.booleanValue()) {
                    this.getLog().info((CharSequence)("using already extracted properties from parent module: " + this.toMap(parentProps)));
                }
                this.setProperties(parentProps, this.project.getProperties());
                break block17;
lbl44:
                // 1 sources

                this.getLog().warn((CharSequence)"Cannot extract JGit version: something wrong with build process, we're not in parent, not in subproject!");
                this.fillPropsUnknown();
            }
            catch (Exception e) {
                try {
                    message = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
                    this.getLog().error((CharSequence)message);
                    throw new MojoFailureException(message, (Throwable)e);
                }
                catch (Throwable var10_13) {
                    duration = System.currentTimeMillis() - start;
                    if (this.verbose.booleanValue()) {
                        this.getLog().info((CharSequence)String.format("JGit BuildNumber Maven Plugin - end (execution time: %d ms)", new Object[]{duration}));
                    }
                    throw var10_13;
                }
            }
        }
        duration = System.currentTimeMillis() - start;
        if (this.verbose.booleanValue()) {
            this.getLog().info((CharSequence)String.format("JGit BuildNumber Maven Plugin - end (execution time: %d ms)", new Object[]{duration}));
        }
    }

    private void saveResultToBuildContext(String paramsKey, List<Object> currentParams, String resultKey, Map<String, String> result) {
        if (this.buildContext != null) {
            this.buildContext.setValue(paramsKey, currentParams);
            this.buildContext.setValue(resultKey, result);
        }
    }

    private Map<String, String> getCachedResultFromBuildConext(String paramsKey, List<Object> currentParams, String resultKey) {
        if (this.buildContext != null && this.buildContext.isIncremental()) {
            List cachedParams;
            if (this.verbose.booleanValue()) {
                this.getLog().info((CharSequence)"m2e incremental build detected");
            }
            if (Objects.equals(cachedParams = (List)this.buildContext.getValue(paramsKey), currentParams)) {
                Map cachedResult = (Map)this.buildContext.getValue(resultKey);
                return cachedResult;
            }
        }
        return null;
    }

    private Map<String, String> toMap(Properties props) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String propertyName : BuildNumberExtractor.propertyNames) {
            map.put(propertyName, props.getProperty(this.namespace + "." + propertyName));
        }
        return map;
    }

    private void setProperties(Map<String, String> source, Properties target) {
        for (Map.Entry<String, String> e : source.entrySet()) {
            target.setProperty(this.namespace + "." + e.getKey(), e.getValue());
        }
    }

    private void setProperties(Properties source, Properties target) {
        for (String propertyName : BuildNumberExtractor.propertyNames) {
            String prefixedName = this.namespace + "." + propertyName;
            target.setProperty(prefixedName, source.getProperty(prefixedName));
        }
    }

    private void fillPropsUnknown() {
        Properties props = this.project.getProperties();
        for (String propertyName : BuildNumberExtractor.propertyNames) {
            props.setProperty(this.namespace + "." + propertyName, "UNKNOWN-" + propertyName);
        }
    }

    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDirtyValue() {
        return this.dirtyValue;
    }

    public Integer getShortRevisionLength() {
        return this.shortRevisionLength;
    }

    public String getGitDateFormat() {
        return this.gitDateFormat;
    }

    public String getBuildDateFormat() {
        return this.buildDateFormat;
    }

    public String getDateFormatTimeZone() {
        return this.dateFormatTimeZone;
    }

    public String getCountCommitsSinceInclusive() {
        return this.countCommitsSinceInclusive;
    }

    public String getCountCommitsSinceExclusive() {
        return this.countCommitsSinceExclusive;
    }

    public String getCountCommitsInPath() {
        return this.countCommitsInPath;
    }

    public String getBuildNumberFormat() {
        return this.buildNumberFormat;
    }

    public File getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    public Boolean getRunOnlyAtExecutionRoot() {
        return this.runOnlyAtExecutionRoot;
    }

    public Boolean getSkip() {
        return this.skip;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public File getExecutionRootDirectory() {
        return this.executionRootDirectory;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenProject getParentProject() {
        return this.parentProject;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setDirtyValue(String dirtyValue) {
        this.dirtyValue = dirtyValue;
    }

    public void setShortRevisionLength(Integer shortRevisionLength) {
        this.shortRevisionLength = shortRevisionLength;
    }

    public void setGitDateFormat(String gitDateFormat) {
        this.gitDateFormat = gitDateFormat;
    }

    public void setBuildDateFormat(String buildDateFormat) {
        this.buildDateFormat = buildDateFormat;
    }

    public void setDateFormatTimeZone(String dateFormatTimeZone) {
        this.dateFormatTimeZone = dateFormatTimeZone;
    }

    public void setCountCommitsSinceInclusive(String countCommitsSinceInclusive) {
        this.countCommitsSinceInclusive = countCommitsSinceInclusive;
    }

    public void setCountCommitsSinceExclusive(String countCommitsSinceExclusive) {
        this.countCommitsSinceExclusive = countCommitsSinceExclusive;
    }

    public void setCountCommitsInPath(String countCommitsInPath) {
        this.countCommitsInPath = countCommitsInPath;
    }

    public void setBuildNumberFormat(String buildNumberFormat) {
        this.buildNumberFormat = buildNumberFormat;
    }

    public void setRepositoryDirectory(File repositoryDirectory) {
        this.repositoryDirectory = repositoryDirectory;
    }

    public void setRunOnlyAtExecutionRoot(Boolean runOnlyAtExecutionRoot) {
        this.runOnlyAtExecutionRoot = runOnlyAtExecutionRoot;
    }

    public void setSkip(Boolean skip) {
        this.skip = skip;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setExecutionRootDirectory(File executionRootDirectory) {
        this.executionRootDirectory = executionRootDirectory;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setParentProject(MavenProject parentProject) {
        this.parentProject = parentProject;
    }

    private /* synthetic */ void lambda$execute$0(String msg) {
        this.getLog().info((CharSequence)msg);
    }
}

