/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.MethodClassKey;
import org.springframework.lang.Nullable;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.ClassUtils;

public abstract class AbstractFallbackTransactionAttributeSource
implements TransactionAttributeSource {
    private static final TransactionAttribute NULL_TRANSACTION_ATTRIBUTE = new DefaultTransactionAttribute(){

        @Override
        public String toString() {
            return "null";
        }
    };
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<Object, TransactionAttribute> attributeCache = new ConcurrentHashMap<Object, TransactionAttribute>(1024);

    @Override
    @Nullable
    public TransactionAttribute getTransactionAttribute(Method method, @Nullable Class<?> targetClass) {
        if (method.getDeclaringClass() == Object.class) {
            return null;
        }
        Object cacheKey = this.getCacheKey(method, targetClass);
        TransactionAttribute cached = this.attributeCache.get(cacheKey);
        if (cached != null) {
            if (cached == NULL_TRANSACTION_ATTRIBUTE) {
                return null;
            }
            return cached;
        }
        TransactionAttribute txAttr = this.computeTransactionAttribute(method, targetClass);
        if (txAttr == null) {
            this.attributeCache.put(cacheKey, NULL_TRANSACTION_ATTRIBUTE);
        } else {
            String methodIdentification = ClassUtils.getQualifiedMethodName((Method)method, targetClass);
            if (txAttr instanceof DefaultTransactionAttribute) {
                ((DefaultTransactionAttribute)txAttr).setDescriptor(methodIdentification);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Adding transactional method '" + methodIdentification + "' with attribute: " + txAttr));
            }
            this.attributeCache.put(cacheKey, txAttr);
        }
        return txAttr;
    }

    protected Object getCacheKey(Method method, @Nullable Class<?> targetClass) {
        return new MethodClassKey(method, targetClass);
    }

    @Nullable
    protected TransactionAttribute computeTransactionAttribute(Method method, @Nullable Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
        TransactionAttribute txAttr = this.findTransactionAttribute(specificMethod);
        txAttr = this.merge(txAttr, this.findTransactionAttribute(targetClass));
        if (specificMethod != method) {
            txAttr = this.merge(txAttr, this.findTransactionAttribute(method));
            txAttr = this.merge(txAttr, this.findTransactionAttribute(method.getDeclaringClass()));
        }
        return txAttr;
    }

    @Nullable
    protected abstract TransactionAttribute findTransactionAttribute(Class<?> var1);

    @Nullable
    protected abstract TransactionAttribute findTransactionAttribute(Method var1);

    protected boolean allowPublicMethodsOnly() {
        return false;
    }

    @Nullable
    private TransactionAttribute merge(@Nullable TransactionAttribute primary, @Nullable TransactionAttribute secondary) {
        DefaultTransactionAttribute s;
        DefaultTransactionAttribute p;
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        if (primary instanceof DefaultTransactionAttribute && secondary instanceof DefaultTransactionAttribute) {
            p = (DefaultTransactionAttribute)primary;
            s = (DefaultTransactionAttribute)secondary;
            if (p.getQualifier() == null || p.getQualifier().isEmpty()) {
                p.setQualifier(s.getQualifier());
            }
            if (p.getDescriptor() == null || p.getDescriptor().isEmpty()) {
                p.setDescriptor(s.getDescriptor());
            }
            if (p.getName() == null || p.getName().isEmpty()) {
                p.setName(s.getName());
            }
            if (p.getPropagationBehavior() == 0) {
                p.setPropagationBehavior(s.getPropagationBehavior());
            }
            if (p.getIsolationLevel() == -1) {
                p.setIsolationLevel(s.getIsolationLevel());
            }
            if (p.getTimeout() == -1) {
                p.setTimeout(s.getTimeout());
            }
            if (!p.isReadOnly()) {
                p.setReadOnly(s.isReadOnly());
            }
        }
        if (primary instanceof RuleBasedTransactionAttribute && secondary instanceof RuleBasedTransactionAttribute) {
            p = (RuleBasedTransactionAttribute)primary;
            s = (RuleBasedTransactionAttribute)secondary;
            if (((RuleBasedTransactionAttribute)p).getRollbackRules() == null || ((RuleBasedTransactionAttribute)p).getRollbackRules().isEmpty()) {
                ((RuleBasedTransactionAttribute)p).setRollbackRules(((RuleBasedTransactionAttribute)s).getRollbackRules());
            }
        }
        return primary;
    }
}

