/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight;

import com.labymedia.ultralight.UltralightLoadException;
import com.labymedia.ultralight.os.Architecture;
import com.labymedia.ultralight.os.OperatingSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class UltralightJava {
    public static void extractNativeLibrary(Path nativesDir) throws UltralightLoadException {
        OperatingSystem operatingSystem = OperatingSystem.get();
        Architecture architecture = Architecture.get();
        String nameWithArchitecture = operatingSystem.mapLibraryName("ultralight-java-" + architecture.getBits());
        try {
            if (UltralightJava.extractResource("/native-binaries/" + nameWithArchitecture, nativesDir.resolve(nameWithArchitecture))) {
                return;
            }
        }
        catch (IOException e) {
            throw new UltralightLoadException("Failed to extract native library", e);
        }
        String nameWithoutArchitecture = operatingSystem.mapLibraryName("ultralight-java");
        try {
            if (UltralightJava.extractResource("/native-binaries/" + nameWithoutArchitecture, nativesDir.resolve(nameWithoutArchitecture))) {
                return;
            }
        }
        catch (IOException e) {
            throw new UltralightLoadException("Failed to extract native library", e);
        }
        throw new UltralightLoadException("No library found for the requested architecture and operating system");
    }

    private static boolean extractResource(String resourcePath, Path targetFile) throws IOException {
        try (InputStream stream = UltralightJava.class.getResourceAsStream(resourcePath);){
            if (stream == null) {
                boolean bl = false;
                return bl;
            }
            Path targetDir = targetFile.getParent();
            if (!Files.isDirectory(targetDir, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            Files.copy(stream, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return true;
    }

    public static void load(Path nativesDir) throws UltralightLoadException {
        UltralightJava.load(nativesDir, true);
    }

    public static void load(Path nativesDir, boolean autoloadDependencies) throws UltralightLoadException {
        OperatingSystem operatingSystem = OperatingSystem.get();
        Architecture architecture = Architecture.get();
        if (autoloadDependencies) {
            for (String library : new String[]{"UltralightCore", "WebCore", "Ultralight", "AppCore"}) {
                Path libraryPath = UltralightJava.determineLibraryPath(nativesDir, library, operatingSystem, architecture);
                try {
                    System.load(libraryPath.toAbsolutePath().toString());
                }
                catch (UnsatisfiedLinkError e) {
                    throw new UltralightLoadException("Failed to load native dependency " + library + " (tried to load from " + libraryPath + ")", e);
                }
            }
        }
        Path ultralightLibrary = UltralightJava.determineLibraryPath(nativesDir, "ultralight-java", operatingSystem, architecture);
        try {
            System.load(ultralightLibrary.toAbsolutePath().toString());
        }
        catch (UnsatisfiedLinkError e) {
            throw new UltralightLoadException("Failed to load native ultralight-java library", e);
        }
    }

    private static Path determineLibraryPath(Path nativesDir, String libraryName, OperatingSystem operatingSystem, Architecture architecture) throws UltralightLoadException {
        Path pathWithArchitecture = nativesDir.resolve(operatingSystem.mapLibraryName(libraryName + "-" + architecture.getBits()));
        if (Files.isRegularFile(pathWithArchitecture, new LinkOption[0])) {
            return pathWithArchitecture;
        }
        Path pathWithoutArchitecture = nativesDir.resolve(operatingSystem.mapLibraryName(libraryName));
        if (Files.isRegularFile(pathWithoutArchitecture, new LinkOption[0])) {
            return pathWithoutArchitecture;
        }
        throw new UltralightLoadException("Failed to find library " + libraryName);
    }
}

