/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.config;

import com.labymedia.ultralight.annotation.NativeType;
import com.labymedia.ultralight.annotation.Unsigned;
import com.labymedia.ultralight.config.FaceWinding;
import com.labymedia.ultralight.config.FontHinting;

@NativeType(value="ultralight::Config")
public class UltralightConfig {
    @NativeType(value="ultralight::String16")
    private String cachePath;
    private FaceWinding faceWinding = FaceWinding.COUNTER_CLOCKWISE;
    private FontHinting fontHinting = FontHinting.NORMAL;
    private double fontGamma = 1.8;
    @NativeType(value="ultralight::String16")
    private String userStylesheet = "";
    private boolean forceRepaint = false;
    private double animationTimerDelay = 0.016666666666666666;
    private double scrollTimerDelay = 0.016666666666666666;
    private double recycleDelay = 4.0;
    @NativeType(value="uint32_t")
    @Unsigned
    private long memoryCacheSize = 0x4000000L;
    @NativeType(value="uint32_t")
    @Unsigned
    private long pageCacheSize = 0L;
    @NativeType(value="uint32_t")
    @Unsigned
    private long overrideRamSize = 0L;
    @NativeType(value="uint32_t")
    @Unsigned
    private long minLargeHeapSize = 0x2000000L;
    @NativeType(value="uint32_t")
    @Unsigned
    private long minSmallHeapSize = 0x100000L;

    @Deprecated
    public UltralightConfig resourcePath(String unused) {
        return this;
    }

    public UltralightConfig cachePath(String cachePath) {
        this.cachePath = cachePath;
        return this;
    }

    public UltralightConfig faceWinding(FaceWinding faceWinding) {
        this.faceWinding = faceWinding;
        return this;
    }

    public UltralightConfig fontHinting(FontHinting fontHinting) {
        this.fontHinting = fontHinting;
        return this;
    }

    public UltralightConfig fontGamma(double fontGamma) {
        this.fontGamma = fontGamma;
        return this;
    }

    public UltralightConfig userStylesheet(String userStylesheet) {
        this.userStylesheet = userStylesheet;
        return this;
    }

    public UltralightConfig forceRepaint(boolean forceRepaint) {
        this.forceRepaint = forceRepaint;
        return this;
    }

    public UltralightConfig animationTimerDelay(double animationTimerDelay) {
        this.animationTimerDelay = animationTimerDelay;
        return this;
    }

    public UltralightConfig scrollTimerDelay(double scrollTimerDelay) {
        this.scrollTimerDelay = scrollTimerDelay;
        return this;
    }

    public UltralightConfig recycleDelay(double recycleDelay) {
        this.recycleDelay = recycleDelay;
        return this;
    }

    public UltralightConfig memoryCacheSize(long memoryCacheSize) {
        if (this.pageCacheSize < 0L) {
            throw new IllegalArgumentException("memoryCacheSize can't be less than 0");
        }
        this.memoryCacheSize = memoryCacheSize;
        return this;
    }

    public UltralightConfig pageCacheSize(long pageCacheSize) {
        if (pageCacheSize < 0L) {
            throw new IllegalArgumentException("pageCacheSize can't be less than 0");
        }
        this.pageCacheSize = pageCacheSize;
        return this;
    }

    public UltralightConfig overrideRamSize(long overrideRamSize) {
        if (overrideRamSize < 0L) {
            throw new IllegalArgumentException("overrideRamSize can't be less than 0");
        }
        this.overrideRamSize = overrideRamSize;
        return this;
    }

    public UltralightConfig minLargeHeapSize(long minLargeHeapSize) {
        if (minLargeHeapSize < 0L) {
            throw new IllegalArgumentException("minLargeHeapSize can't be less than 0");
        }
        this.minLargeHeapSize = minLargeHeapSize;
        return this;
    }

    public UltralightConfig minSmallHeapSize(long minSmallHeapSize) {
        if (minSmallHeapSize < 0L) {
            throw new IllegalArgumentException("minSmallHeapSize can't be less than 0");
        }
        this.minSmallHeapSize = minSmallHeapSize;
        return this;
    }
}

