/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.ffi.gc.impl;

import com.labymedia.ultralight.ffi.gc.BoundDeleter;
import com.labymedia.ultralight.ffi.gc.DeletableObject;
import com.labymedia.ultralight.ffi.gc.FFIGarbageCollector;
import com.labymedia.ultralight.util.Util;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultFFIGarbageCollectorImpl
implements FFIGarbageCollector {
    private final ReferenceQueue<DeletableObject<?>> queue = new ReferenceQueue();
    private final Map<Reference<DeletableObject<?>>, BoundDeleter<?>> deleters = new ConcurrentHashMap();

    public DefaultFFIGarbageCollectorImpl() {
        Thread collectionThread = new Thread(this::run, "Ultralight garbage collector");
        collectionThread.setDaemon(true);
        collectionThread.start();
    }

    @Override
    public <T> void submit(DeletableObject<T> value, BoundDeleter<T> deleter) {
        WeakReference reference = new WeakReference(value, this.queue);
        this.deleters.put((Reference<DeletableObject<?>>)Util.forceCast(reference), deleter);
    }

    private void run() {
        while (true) {
            try {
                while (true) {
                    Reference<DeletableObject<?>> reference;
                    BoundDeleter<?> deleter;
                    if ((deleter = this.deleters.remove(reference = this.queue.remove())) == null) {
                        throw new IllegalStateException("Object in reference queue which does not have a deleter associated");
                    }
                    deleter.delete();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

