/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.javascript;

import com.labymedia.ultralight.annotation.NativeType;
import com.labymedia.ultralight.ffi.ObjectWithHandle;
import com.labymedia.ultralight.javascript.JavascriptClass;
import com.labymedia.ultralight.javascript.JavascriptContextLock;
import com.labymedia.ultralight.javascript.JavascriptException;
import com.labymedia.ultralight.javascript.JavascriptGlobalContext;
import com.labymedia.ultralight.javascript.JavascriptLockedObject;
import com.labymedia.ultralight.javascript.JavascriptObject;
import com.labymedia.ultralight.javascript.JavascriptValue;

@NativeType(value="JSContextRef")
public class JavascriptContext
implements ObjectWithHandle,
JavascriptLockedObject {
    private final long handle;
    private final JavascriptContextLock lock;

    protected JavascriptContext(@NativeType(value="JSGlobalContextRef") long handle, JavascriptContextLock lock) {
        this.handle = handle;
        this.lock = lock;
    }

    public native JavascriptGlobalContext getGlobalContext();

    public native JavascriptObject getGlobalObject();

    public native JavascriptValue makeUndefined();

    public native JavascriptValue makeNull();

    public native JavascriptValue makeBoolean(boolean var1);

    public native JavascriptValue makeNumber(double var1);

    public native JavascriptValue makeString(String var1);

    public native JavascriptValue makeSymbol(String var1);

    public native JavascriptValue makeFromJSON(String var1);

    public JavascriptObject makeObject(JavascriptClass clazz) {
        return this.makeObject(clazz, null);
    }

    public native JavascriptObject makeObject(JavascriptClass var1, Object var2);

    public native JavascriptObject makeArray(JavascriptValue ... var1) throws JavascriptException;

    public native JavascriptObject makeDate(JavascriptValue ... var1) throws JavascriptException;

    public native JavascriptObject makeError(JavascriptValue ... var1) throws JavascriptException;

    public native JavascriptObject makeRegExp(JavascriptValue ... var1) throws JavascriptException;

    public native JavascriptObject makeFunction(String var1, String[] var2, String var3, String var4, int var5) throws JavascriptException;

    public native void garbageCollect();

    @Override
    public void contextUnlocking() {
    }

    @Override
    public JavascriptContextLock getLock() {
        return this.lock;
    }

    @Override
    public long getContextHandle() {
        return this.lock.getContext().getHandle();
    }

    @Override
    public long getLockHandle() {
        return this.lock.getHandle();
    }

    @Override
    public long getHandle() {
        if (!this.lock.isLocked()) {
            throw new IllegalStateException("JavascriptContext is not locked anymore");
        }
        return this.handle;
    }
}

