/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.javascript;

import com.labymedia.ultralight.annotation.NativeCall;
import com.labymedia.ultralight.annotation.NativeType;
import com.labymedia.ultralight.ffi.ObjectWithHandle;
import com.labymedia.ultralight.javascript.JavascriptContext;
import com.labymedia.ultralight.javascript.JavascriptLockedObject;
import java.util.ArrayList;
import java.util.List;

@NativeType(value="ultralight::Ref<ultralight::JSContext>")
public class JavascriptContextLock
implements AutoCloseable,
ObjectWithHandle {
    private final long handle;
    private final List<JavascriptLockedObject> lockedObjects;
    private boolean isLocked;

    @NativeCall
    private JavascriptContextLock(long handle) {
        this.handle = handle;
        this.lockedObjects = new ArrayList<JavascriptLockedObject>();
        this.isLocked = true;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void addDependency(JavascriptLockedObject object) {
        this.lockedObjects.add(object);
    }

    @Override
    public void close() {
        this.unlock();
    }

    public void unlock() {
        if (this.isLocked) {
            for (JavascriptLockedObject object : this.lockedObjects) {
                object.contextUnlocking();
            }
            this.lockedObjects.clear();
            this.release();
            this.isLocked = false;
        }
    }

    @Override
    public long getHandle() {
        if (!this.isLocked) {
            throw new IllegalStateException("JavascriptContextLock is not locked anymore");
        }
        return this.handle;
    }

    public native JavascriptContext getContext();

    private native void release();
}

