/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.javascript;

import com.labymedia.ultralight.annotation.NativeCall;
import com.labymedia.ultralight.annotation.NativeType;
import com.labymedia.ultralight.annotation.Unstable;
import com.labymedia.ultralight.ffi.ObjectWithHandle;
import com.labymedia.ultralight.javascript.JavascriptClass;
import com.labymedia.ultralight.javascript.JavascriptContextLock;
import com.labymedia.ultralight.javascript.JavascriptException;
import com.labymedia.ultralight.javascript.JavascriptLockedObject;
import com.labymedia.ultralight.javascript.JavascriptObject;
import com.labymedia.ultralight.javascript.JavascriptProtectedValue;
import com.labymedia.ultralight.javascript.JavascriptType;
import com.labymedia.ultralight.javascript.JavascriptTypedArrayType;
import java.util.Objects;

@NativeType(value="JSValueRef")
public class JavascriptValue
implements ObjectWithHandle,
JavascriptLockedObject {
    private final long handle;
    private final JavascriptContextLock lock;

    @NativeCall
    JavascriptValue(@NativeType(value="JSValueRef") long handle, JavascriptContextLock lock) {
        this.handle = handle;
        this.lock = lock;
        if (this.lock != null) {
            this.lock.addDependency(this);
        }
    }

    public native JavascriptProtectedValue protect();

    public native JavascriptType getType();

    public native boolean isUndefined();

    public native boolean isNull();

    public native boolean isBoolean();

    public native boolean isNumber();

    public native boolean isString();

    public native boolean isSymbol();

    public native boolean isObject();

    public native boolean isOfClass(JavascriptClass var1);

    public native boolean isArray();

    public native boolean isDate();

    public native JavascriptTypedArrayType getTypedArrayType();

    public native boolean isEqual(JavascriptValue var1);

    public native boolean isStrictEqual(JavascriptValue var1);

    @Unstable(value="Comparison of Javascript objects is subject to change")
    public boolean equals(Object other) {
        if (!(other instanceof JavascriptValue)) {
            return false;
        }
        return ((JavascriptValue)other).handle == this.handle;
    }

    public native boolean isInstanceOfConstructor(JavascriptObject var1) throws JavascriptException;

    public native String toJson(short var1);

    public native boolean toBoolean();

    public native double toNumber();

    public native String toStringCopy();

    public native JavascriptObject toObject() throws JavascriptException;

    public String toString() {
        if (this.lock != null && this.lock.isLocked()) {
            try {
                return this.toStringCopy();
            }
            catch (JavascriptException ignored) {
                return "JavascriptValue{handle = " + this.handle + ", lock = " + this.lock.getHandle() + "}";
            }
        }
        return "JavascriptValue{handle = " + this.handle + ", lock = none}";
    }

    public int hashCode() {
        return Objects.hashCode(this.handle);
    }

    @Override
    public long getHandle() {
        if (this.lock == null) {
            throw new IllegalStateException("This value has never been locked");
        }
        if (!this.lock.isLocked()) {
            throw new IllegalStateException("JavascriptContext is not locked anymore");
        }
        return this.handle;
    }

    @Override
    public long getContextHandle() {
        if (this.lock == null) {
            throw new IllegalStateException("This value has never been locked");
        }
        if (!this.lock.isLocked()) {
            throw new IllegalStateException("JavascriptContext is not locked anymore");
        }
        return this.lock.getContext().getHandle();
    }

    @Override
    public long getLockHandle() {
        if (this.lock == null) {
            throw new IllegalStateException("This value has never been locked");
        }
        if (!this.lock.isLocked()) {
            throw new IllegalStateException("JavascriptContext is not locked anymore");
        }
        return this.lock.getHandle();
    }

    @Override
    public native void contextUnlocking();

    @Override
    public JavascriptContextLock getLock() {
        return this.lock;
    }
}

