/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.math;

import com.labymedia.ultralight.annotation.NativeType;
import java.util.Objects;

@NativeType(value="ultralight::IntRect")
public final class IntRect {
    private int left;
    private int top;
    private int right;
    private int bottom;

    public IntRect() {
        this.left = 0;
        this.top = 0;
        this.right = 0;
        this.bottom = 0;
    }

    public IntRect(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public int width() {
        return this.right - this.left;
    }

    public int height() {
        return this.bottom - this.top;
    }

    public int x() {
        return this.left;
    }

    public int y() {
        return this.top;
    }

    public int centerX() {
        return (int)((float)Math.round(this.left + this.right) * 0.5f);
    }

    public int centerY() {
        return (int)((float)Math.round(this.top + this.bottom) * 0.5f);
    }

    public boolean isValid() {
        return this.width() > 0 && this.height() > 0;
    }

    public void inset(int dx, int dy) {
        this.left += dx;
        this.top += dy;
        this.right -= dx;
        this.bottom -= dy;
    }

    public void outset(int dx, int dy) {
        this.inset(-dx, -dy);
    }

    public void move(int dx, int dy) {
        this.left += dx;
        this.top += dy;
        this.right += dx;
        this.bottom += dy;
    }

    private boolean isEmpty() {
        return this.left == 0 && this.top == 0 && this.right == 0 && this.bottom == 0;
    }

    public void join(IntRect other) {
        if (this.isEmpty()) {
            this.left = other.left;
            this.top = other.top;
            this.right = other.right;
            this.bottom = other.bottom;
        } else {
            if (other.left < this.left) {
                this.left = other.left;
            }
            if (other.top < this.top) {
                this.top = other.top;
            }
            if (other.right > this.right) {
                this.right = other.right;
            }
            if (other.bottom > this.bottom) {
                this.bottom = other.bottom;
            }
        }
    }

    public boolean contains(IntRect other) {
        return this.left <= other.left && this.top <= other.top && this.right >= other.right && this.bottom >= other.bottom;
    }

    public boolean intersects(IntRect other) {
        return other.left < this.right - 1 && other.right >= this.left && other.top < this.bottom - 1 && other.bottom >= this.top;
    }

    public IntRect intersect(IntRect other) {
        return new IntRect(Math.max(this.left, other.left), Math.max(this.top, other.top), Math.min(other.right, this.right), Math.min(other.bottom, this.bottom));
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntRect)) {
            return false;
        }
        IntRect intRect = (IntRect)o;
        return this.left == intRect.left && this.top == intRect.top && this.right == intRect.right && this.bottom == intRect.bottom;
    }

    public int hashCode() {
        return Objects.hash(this.left, this.top, this.right, this.bottom);
    }
}

