/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.math;

import com.labymedia.ultralight.annotation.NativeType;
import java.util.Arrays;

@NativeType(value="ultralight::Vec4")
public class Vec4 {
    private final float[] value = new float[4];

    public Vec4() {
    }

    public Vec4(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public Vec4(float value) {
        this.set(value, value, value, value);
    }

    public Vec4(float[] value) {
        if (value.length != 4) {
            throw new IllegalArgumentException("Expected value to be exactly 4 floats");
        }
        System.arraycopy(value, 0, this.value, 0, 4);
    }

    public void set(float x, float y, float z, float w) {
        this.value[0] = x;
        this.value[1] = y;
        this.value[2] = z;
        this.value[3] = w;
    }

    public float[] getValue() {
        return this.value;
    }

    public float[] getValueCopy() {
        float[] copy = new float[4];
        System.arraycopy(this.value, 0, copy, 0, 4);
        return copy;
    }

    public float getX() {
        return this.value[0];
    }

    public float getY() {
        return this.value[1];
    }

    public float getZ() {
        return this.value[2];
    }

    public float getW() {
        return this.value[3];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec4 vec4 = (Vec4)o;
        return Arrays.equals(this.value, vec4.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

