/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.os;

public enum Architecture {
    AMD64(64),
    I386(32),
    UNKNOWN(-1);

    private final int bits;

    private Architecture(int bits) {
        this.bits = bits;
    }

    public int getBits() {
        return this.bits;
    }

    public static Architecture get() {
        String arch = System.getProperty("os.arch", "unknown").toLowerCase();
        String dataModel = System.getProperty("sun.arch.data.model", "unknown").toLowerCase();
        if (arch.equals("unknown") && dataModel.equals("unknown")) {
            return UNKNOWN;
        }
        if (arch.contains("64") || dataModel.contains("64")) {
            return AMD64;
        }
        return I386;
    }
}

