/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.os;

import java.util.function.Function;

public enum OperatingSystem {
    LINUX(s -> "lib" + s + ".so"),
    WINDOWS(s -> s + ".dll"),
    MAC_OS(s -> "lib" + s + ".dylib"),
    UNKNOWN(LINUX::mapLibraryName);

    private final Function<String, String> libraryNameMapper;

    private OperatingSystem(Function<String, String> libraryNameMapper) {
        this.libraryNameMapper = libraryNameMapper;
    }

    public String mapLibraryName(String libraryName) {
        return this.libraryNameMapper.apply(libraryName);
    }

    public static OperatingSystem get() {
        String systemName = System.getProperty("os.name", "unknown").toLowerCase();
        if (systemName.contains("nux") || systemName.contains("nix")) {
            return LINUX;
        }
        if (systemName.contains("mac")) {
            return MAC_OS;
        }
        if (systemName.contains("windows")) {
            return WINDOWS;
        }
        return UNKNOWN;
    }
}

