/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind;

import com.labymedia.ultralight.databind.DatabindConfiguration;
import com.labymedia.ultralight.databind.DatabindJavascriptClass;
import com.labymedia.ultralight.databind.cache.JavascriptClassCache;
import com.labymedia.ultralight.databind.context.ContextProviderFactory;
import com.labymedia.ultralight.databind.utils.JavascriptConversionUtils;
import com.labymedia.ultralight.javascript.JavascriptClass;

public final class Databind {
    private final DatabindConfiguration configuration;
    private final JavascriptClassCache classCache;
    private final ContextProviderFactory contextProviderFactory;
    private final JavascriptConversionUtils conversionUtils;

    public Databind(DatabindConfiguration configuration) {
        this.configuration = configuration;
        this.classCache = configuration.classCache();
        this.contextProviderFactory = configuration.contextProviderFactory();
        this.conversionUtils = new JavascriptConversionUtils(this);
    }

    public JavascriptClass toJavascript(Class<?> javaClass) {
        return this.toJavascript(javaClass, true);
    }

    public JavascriptClass toJavascript(Class<?> javaClass, boolean ignoreAutomaticPrototypeSetting) {
        JavascriptClass javascriptClass = this.classCache.get(javaClass.getName());
        if (javascriptClass == null) {
            if (!ignoreAutomaticPrototypeSetting && this.configuration.automaticPrototype()) {
                throw new IllegalStateException("Cannot automatically import a prototype due to databind configuration");
            }
            javascriptClass = this.classCache.put(javaClass.getName(), DatabindJavascriptClass.create(this.configuration, this.conversionUtils, javaClass, this.classCache).bake());
        }
        return javascriptClass;
    }

    public JavascriptConversionUtils getConversionUtils() {
        return this.conversionUtils;
    }

    public ContextProviderFactory getContextProviderFactory() {
        return this.contextProviderFactory;
    }

    public boolean supportsFunctionalConversion() {
        return this.contextProviderFactory != null;
    }
}

