/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind;

import com.labymedia.ultralight.databind.cache.JavascriptClassCache;
import com.labymedia.ultralight.databind.cache.NaiveJavascriptClassCache;
import com.labymedia.ultralight.databind.call.HeuristicMethodChooser;
import com.labymedia.ultralight.databind.call.MethodChooser;
import com.labymedia.ultralight.databind.call.property.PropertyCaller;
import com.labymedia.ultralight.databind.call.property.ReflectivePropertyCaller;
import com.labymedia.ultralight.databind.context.ContextProviderFactory;

public final class DatabindConfiguration {
    private final JavascriptClassCache classCache;
    private final MethodChooser methodChooser;
    private final PropertyCaller.Factory propertyCallerFactory;
    private final boolean automaticPrototype;
    private final ContextProviderFactory contextProviderFactory;

    private DatabindConfiguration(JavascriptClassCache classCache, MethodChooser methodChooser, PropertyCaller.Factory propertyCallerFactory, boolean automaticPrototype, ContextProviderFactory contextProviderFactory) {
        this.classCache = classCache;
        this.methodChooser = methodChooser;
        this.propertyCallerFactory = propertyCallerFactory;
        this.automaticPrototype = automaticPrototype;
        this.contextProviderFactory = contextProviderFactory;
    }

    public JavascriptClassCache classCache() {
        return this.classCache;
    }

    public MethodChooser methodChooser() {
        return this.methodChooser;
    }

    public PropertyCaller.Factory propertyCallerFactory() {
        return this.propertyCallerFactory;
    }

    public boolean automaticPrototype() {
        return this.automaticPrototype;
    }

    public ContextProviderFactory contextProviderFactory() {
        return this.contextProviderFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private JavascriptClassCache classCache = new NaiveJavascriptClassCache();
        private MethodChooser methodChooser = new HeuristicMethodChooser();
        private PropertyCaller.Factory propertyCallerFactory = new ReflectivePropertyCaller.Factory();
        private boolean automaticPrototype = true;
        private ContextProviderFactory contextProviderFactory;

        private Builder() {
        }

        public Builder classCache(JavascriptClassCache classCache) {
            this.classCache = classCache;
            return this;
        }

        public Builder methodChooser(MethodChooser methodChooser) {
            this.methodChooser = methodChooser;
            return this;
        }

        public Builder propertyCallerFactory(PropertyCaller.Factory propertyCallerFactory) {
            this.propertyCallerFactory = propertyCallerFactory;
            return this;
        }

        public Builder automaticPrototype(boolean automaticPrototype) {
            this.automaticPrototype = automaticPrototype;
            return this;
        }

        public Builder contextProviderFactory(ContextProviderFactory contextProviderFactory) {
            this.contextProviderFactory = contextProviderFactory;
            return this;
        }

        public DatabindConfiguration build() {
            return new DatabindConfiguration(this.classCache, this.methodChooser, this.propertyCallerFactory, this.automaticPrototype, this.contextProviderFactory);
        }
    }
}

