/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind;

import com.labymedia.ultralight.databind.DatabindConfiguration;
import com.labymedia.ultralight.databind.DatabindJavascriptMethodHandler;
import com.labymedia.ultralight.databind.cache.JavascriptClassCache;
import com.labymedia.ultralight.databind.call.CallData;
import com.labymedia.ultralight.databind.call.MethodChooser;
import com.labymedia.ultralight.databind.call.property.PropertyCaller;
import com.labymedia.ultralight.databind.utils.JavascriptConversionUtils;
import com.labymedia.ultralight.javascript.JavascriptClass;
import com.labymedia.ultralight.javascript.JavascriptClassDefinition;
import com.labymedia.ultralight.javascript.JavascriptContext;
import com.labymedia.ultralight.javascript.JavascriptObject;
import com.labymedia.ultralight.javascript.JavascriptValue;
import com.labymedia.ultralight.javascript.interop.JavascriptInteropException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DatabindJavascriptClass {
    private final JavascriptClassDefinition definition;
    private final DatabindConfiguration configuration;
    private final JavascriptConversionUtils conversionUtils;
    private final MethodChooser methodChooser;
    private final PropertyCaller propertyCaller;
    private final Set<Constructor<?>> constructors = new HashSet();
    private final Map<String, Set<Method>> methods = new HashMap<String, Set<Method>>();
    private final Map<String, Field> fields = new HashMap<String, Field>();
    private final Map<String, JavascriptClass> methodClassCache = new HashMap<String, JavascriptClass>();

    private DatabindJavascriptClass(DatabindConfiguration configuration, JavascriptConversionUtils conversionUtils, String className, JavascriptClass parentClass) {
        this.definition = new JavascriptClassDefinition().name(className).parentClass(parentClass).attributes(2);
        this.configuration = configuration;
        this.conversionUtils = conversionUtils;
        this.methodChooser = configuration.methodChooser();
        this.propertyCaller = configuration.propertyCallerFactory().create();
    }

    private void registerCallbacks() {
        this.definition.onCallAsConstructor(this::onCallAsConstructor);
        this.definition.onHasProperty(this::onHasProperty);
        this.definition.onGetProperty(this::onGetProperty);
        this.definition.onSetProperty(this::onSetProperty);
    }

    private void addConstructors(Collection<Constructor<?>> constructors) {
        this.constructors.addAll(constructors);
    }

    private void addMethods(Collection<Method> methods) {
        for (Method method : methods) {
            String name = method.getName();
            if (method.getName().equals("valueOf") && method.getDeclaringClass().isEnum()) continue;
            if (this.methods.containsKey(name)) {
                this.methods.get(name).add(method);
                continue;
            }
            HashSet<Method> methodSet = new HashSet<Method>();
            methodSet.add(method);
            this.methods.put(name, methodSet);
        }
    }

    private void addFields(Collection<Field> fields) {
        for (Field field : fields) {
            this.fields.put(field.getName(), field);
        }
    }

    private JavascriptObject onCallAsConstructor(JavascriptContext context, JavascriptObject constructor, JavascriptValue[] arguments) throws JavascriptInteropException {
        Data privateData = (Data)constructor.getPrivate();
        if (privateData != null && privateData.instance != null) {
            throw new IllegalStateException("Can't call constructor on an already constructed object");
        }
        CallData<Constructor<?>> callData = this.methodChooser.choose(this.constructors, arguments);
        Constructor<?> method = callData.getTarget();
        List<Object> parameters = callData.constructArguments(context, this.conversionUtils, arguments);
        return context.makeObject(this.bake(), (Object)new Data(this.propertyCaller.callConstructor(method, parameters.toArray()), null));
    }

    private boolean onHasProperty(JavascriptContext context, JavascriptObject object, String propertyName) {
        boolean instanceAvailable = ((Data)object.getPrivate()).instance != null;
        Field f = this.fields.get(propertyName);
        if (f != null && (Modifier.isStatic(f.getModifiers()) || instanceAvailable)) {
            return true;
        }
        Set<Method> methodsWithName = this.methods.get(propertyName);
        if (methodsWithName == null || methodsWithName.isEmpty()) {
            return false;
        }
        if (instanceAvailable) {
            return true;
        }
        for (Method method : methodsWithName) {
            if (!Modifier.isStatic(method.getModifiers())) continue;
            return true;
        }
        return false;
    }

    private JavascriptValue onGetProperty(JavascriptContext context, JavascriptObject object, String propertyName) throws JavascriptInteropException {
        Data privateData = (Data)object.getPrivate();
        Field field = this.fields.get(propertyName);
        if (field != null) {
            return this.conversionUtils.toJavascript(context, this.propertyCaller.callFieldGet(privateData.instance, field), field.getType());
        }
        Set<Method> methodSet = this.methods.get(propertyName);
        if (methodSet == null) {
            return null;
        }
        return context.makeObject(this.methodClassCache.computeIfAbsent(propertyName, key -> DatabindJavascriptMethodHandler.create(this.configuration, this.conversionUtils, this.propertyCaller, methodSet, propertyName).bake()), (Object)new DatabindJavascriptMethodHandler.Data(privateData.instance, null));
    }

    private boolean onSetProperty(JavascriptContext context, JavascriptObject object, String propertyName, JavascriptValue value) throws JavascriptInteropException {
        Data privateData = (Data)object.getPrivate();
        Field field = this.fields.get(propertyName);
        if (field != null) {
            this.propertyCaller.callFieldSet(privateData.instance, field, this.conversionUtils.fromJavascript(value, field.getType()));
            return true;
        }
        if (this.methods.containsKey(propertyName)) {
            throw new UnsupportedOperationException("Can not set a method");
        }
        return false;
    }

    public JavascriptClass bake() {
        return this.definition.bake();
    }

    static DatabindJavascriptClass create(DatabindConfiguration configuration, JavascriptConversionUtils conversionUtils, Class<?> javaClass, JavascriptClassCache classCache) {
        Class<?> superClass = javaClass.getSuperclass();
        JavascriptClass parentClass = null;
        if (superClass != null && javaClass != Object.class) {
            String parentClassName = superClass.getName();
            if (!classCache.contains(parentClassName)) {
                DatabindJavascriptClass databindParent = DatabindJavascriptClass.create(configuration, conversionUtils, superClass, classCache);
                parentClass = classCache.put(parentClassName, databindParent.bake());
            } else {
                parentClass = classCache.get(parentClassName);
            }
        }
        DatabindJavascriptClass javascriptClass = new DatabindJavascriptClass(configuration, conversionUtils, javaClass.getName(), parentClass);
        javascriptClass.registerCallbacks();
        javascriptClass.addConstructors(DatabindJavascriptClass.filterAccessible((AccessibleObject[])javaClass.getConstructors()));
        javascriptClass.addMethods(DatabindJavascriptClass.filterAccessible((AccessibleObject[])javaClass.getMethods()));
        javascriptClass.addFields(DatabindJavascriptClass.filterAccessible((AccessibleObject[])javaClass.getFields()));
        LinkedList toAdd = new LinkedList(Arrays.asList(javaClass.getInterfaces()));
        while (!toAdd.isEmpty()) {
            Class iface = (Class)toAdd.remove();
            toAdd.addAll(Arrays.asList(iface.getInterfaces()));
            javascriptClass.addMethods(DatabindJavascriptClass.filterAccessible((AccessibleObject[])iface.getMethods()));
            javascriptClass.addFields(DatabindJavascriptClass.filterAccessible((AccessibleObject[])iface.getFields()));
        }
        return javascriptClass;
    }

    private static <T extends AccessibleObject> Set<T> filterAccessible(T[] objects) {
        HashSet<T> accessible = new HashSet<T>();
        for (T object : objects) {
            if (!DatabindJavascriptClass.allPublic((Member)object)) continue;
            accessible.add(object);
        }
        return accessible;
    }

    private static boolean allPublic(Member member) {
        Class<?> classToCheck = member.getDeclaringClass();
        return Modifier.isPublic(classToCheck.getModifiers()) && Modifier.isPublic(member.getModifiers());
    }

    public static class Data {
        private final Object instance;
        private final Class<?> javaClass;

        public Data(Object instance, Class<?> javaClass) {
            this.instance = instance;
            this.javaClass = javaClass;
        }

        public Object instance() {
            return this.instance;
        }

        public Class<?> javaClass() {
            return this.javaClass;
        }
    }
}

