/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind;

import com.labymedia.ultralight.databind.DatabindJavascriptMethodHandler;
import com.labymedia.ultralight.databind.utils.JavascriptConversionUtils;
import com.labymedia.ultralight.javascript.JavascriptClass;
import com.labymedia.ultralight.javascript.JavascriptClassDefinition;
import com.labymedia.ultralight.javascript.JavascriptContext;
import com.labymedia.ultralight.javascript.JavascriptObject;
import com.labymedia.ultralight.javascript.JavascriptValue;
import java.util.ArrayList;

public final class DatabindJavascriptExplicitAPI {
    private final JavascriptClassDefinition definition;
    private final JavascriptConversionUtils conversionUtils;

    private DatabindJavascriptExplicitAPI(JavascriptConversionUtils conversionUtils, String name) {
        this.definition = new JavascriptClassDefinition().name(name).attributes(2);
        this.conversionUtils = conversionUtils;
    }

    private void registerCallbacks() {
        this.definition.onCallAsFunction(this::onCallAsFunction);
    }

    private JavascriptValue onCallAsFunction(JavascriptContext context, JavascriptObject function, JavascriptObject thisObject, JavascriptValue[] arguments) {
        Data privateData = (Data)function.getPrivate();
        ArrayList<Class> parameterTypes = new ArrayList<Class>();
        for (JavascriptValue value : arguments) {
            Object object = this.conversionUtils.fromJavascript(value, JavascriptConversionUtils.determineType(value));
            parameterTypes.add((Class)object);
        }
        return context.makeObject(privateData.methodHandler(), (Object)new DatabindJavascriptMethodHandler.Data(privateData.instance, parameterTypes.toArray(new Class[0])));
    }

    public JavascriptClass bake() {
        return this.definition.bake();
    }

    static DatabindJavascriptExplicitAPI create(JavascriptConversionUtils conversionUtils, String name) {
        DatabindJavascriptExplicitAPI javascriptClass = new DatabindJavascriptExplicitAPI(conversionUtils, name);
        javascriptClass.registerCallbacks();
        return javascriptClass;
    }

    public static class Data {
        private final Object instance;
        private final JavascriptClass methodHandler;

        public Data(Object instance, JavascriptClass methodHandler) {
            this.instance = instance;
            this.methodHandler = methodHandler;
        }

        private Object instance() {
            return this.instance;
        }

        public JavascriptClass methodHandler() {
            return this.methodHandler;
        }
    }
}

