/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind;

import com.labymedia.ultralight.databind.DatabindConfiguration;
import com.labymedia.ultralight.databind.DatabindJavascriptExplicitAPI;
import com.labymedia.ultralight.databind.call.CallData;
import com.labymedia.ultralight.databind.call.MethodChooser;
import com.labymedia.ultralight.databind.call.property.PropertyCaller;
import com.labymedia.ultralight.databind.utils.JavascriptConversionUtils;
import com.labymedia.ultralight.javascript.JavascriptClass;
import com.labymedia.ultralight.javascript.JavascriptClassDefinition;
import com.labymedia.ultralight.javascript.JavascriptContext;
import com.labymedia.ultralight.javascript.JavascriptObject;
import com.labymedia.ultralight.javascript.JavascriptValue;
import com.labymedia.ultralight.javascript.interop.JavascriptInteropException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;

public final class DatabindJavascriptMethodHandler {
    private final JavascriptClassDefinition definition;
    private final String name;
    private final MethodChooser methodChooser;
    private final JavascriptConversionUtils conversionUtils;
    private final PropertyCaller propertyCaller;
    private final Set<Method> methodSet;

    private DatabindJavascriptMethodHandler(DatabindConfiguration configuration, JavascriptConversionUtils conversionUtils, PropertyCaller propertyCaller, Set<Method> methodSet, String name) {
        this.definition = new JavascriptClassDefinition().name(name).attributes(2);
        this.name = name;
        this.methodChooser = configuration.methodChooser();
        this.conversionUtils = conversionUtils;
        this.propertyCaller = propertyCaller;
        this.methodSet = methodSet;
    }

    private void registerCallbacks() {
        this.definition.onCallAsFunction(this::onCallAsFunction);
        this.definition.onGetProperty(this::onGetProperty);
    }

    private JavascriptValue onCallAsFunction(JavascriptContext context, JavascriptObject function, JavascriptObject thisObject, JavascriptValue[] arguments) throws JavascriptInteropException {
        Data privateData = (Data)function.getPrivate();
        CallData<Method> callData = privateData.parameterTypes() == null ? this.methodChooser.choose(this.methodSet, arguments) : this.methodChooser.choose(this.methodSet, privateData.parameterTypes(), arguments);
        Method method = callData.getTarget();
        List<Object> parameters = callData.constructArguments(context, this.conversionUtils, arguments);
        Object ret = this.propertyCaller.callMethod(privateData.instance(), method, parameters.toArray());
        Class<?> suggestedReturnType = method.getReturnType();
        if (ret != null) {
            suggestedReturnType = ret.getClass();
        }
        return this.conversionUtils.toJavascript(context, ret, suggestedReturnType);
    }

    private JavascriptValue onGetProperty(JavascriptContext context, JavascriptObject object, String propertyName) {
        if (!propertyName.equals("signature")) {
            return context.makeUndefined();
        }
        Data privateData = (Data)object.getPrivate();
        return context.makeObject(DatabindJavascriptExplicitAPI.create(this.conversionUtils, this.name).bake(), (Object)new DatabindJavascriptExplicitAPI.Data(privateData.instance, this.bake()));
    }

    public JavascriptClass bake() {
        return this.definition.bake();
    }

    static DatabindJavascriptMethodHandler create(DatabindConfiguration configuration, JavascriptConversionUtils conversionUtils, PropertyCaller propertyCaller, Set<Method> methodSet, String name) {
        DatabindJavascriptMethodHandler javascriptClass = new DatabindJavascriptMethodHandler(configuration, conversionUtils, propertyCaller, methodSet, name);
        javascriptClass.registerCallbacks();
        return javascriptClass;
    }

    public static class Data {
        private final Object instance;
        private final Class<?>[] parameterTypes;

        public Data(Object instance, Class<?>[] parameterTypes) {
            this.instance = instance;
            this.parameterTypes = parameterTypes;
        }

        public Object instance() {
            return this.instance;
        }

        public Class<?>[] parameterTypes() {
            return this.parameterTypes;
        }
    }
}

