/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind.call;

import com.labymedia.ultralight.databind.api.InjectJavascriptContext;
import com.labymedia.ultralight.databind.utils.JavascriptConversionUtils;
import com.labymedia.ultralight.javascript.JavascriptContext;
import com.labymedia.ultralight.javascript.JavascriptValue;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;

public class CallData<T extends Executable> {
    private final T target;
    private final VarArgsType varArgsType;

    public CallData(T target, VarArgsType varArgsType) {
        this.target = target;
        this.varArgsType = varArgsType;
    }

    public T getTarget() {
        return this.target;
    }

    public List<Object> constructArguments(JavascriptContext context, JavascriptConversionUtils conversionUtils, JavascriptValue[] arguments) {
        Parameter[] methodParameters = ((Executable)this.target).getParameters();
        ArrayList<Object> parameters = new ArrayList<Object>();
        boolean injectContext = ((AccessibleObject)this.target).isAnnotationPresent(InjectJavascriptContext.class);
        for (int i = 0; i < methodParameters.length; ++i) {
            if (i == 0 && injectContext) {
                parameters.add(context);
                continue;
            }
            if (i == methodParameters.length - 1 && ((Executable)this.target).isVarArgs()) {
                switch (this.varArgsType) {
                    case NONE: {
                        break;
                    }
                    case EMPTY: {
                        parameters.add(Array.newInstance(methodParameters[i].getType().getComponentType(), 0));
                        break;
                    }
                    case COMPACT: {
                        int varArgsCount = arguments.length - i;
                        Class<?> targetType = methodParameters[i].getType().getComponentType();
                        Object args = Array.newInstance(targetType, varArgsCount);
                        for (int x = 0; x < varArgsCount; ++x) {
                            Array.set(args, x, conversionUtils.fromJavascript(arguments[i + x - (injectContext ? 1 : 0)], targetType));
                        }
                        parameters.add(args);
                        break;
                    }
                    case PASS_THROUGH: {
                        parameters.add(conversionUtils.fromJavascript(arguments[i - (injectContext ? 1 : 0)], methodParameters[i].getType()));
                    }
                }
                continue;
            }
            parameters.add(conversionUtils.fromJavascript(arguments[i - (injectContext ? 1 : 0)], methodParameters[i].getType()));
        }
        return parameters;
    }

    public static enum VarArgsType {
        NONE,
        COMPACT,
        PASS_THROUGH,
        EMPTY;

    }
}

