/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind.call;

import com.labymedia.ultralight.databind.api.InjectJavascriptContext;
import com.labymedia.ultralight.databind.call.CallData;
import com.labymedia.ultralight.databind.call.MethodChooser;
import com.labymedia.ultralight.databind.utils.JavascriptConversionUtils;
import com.labymedia.ultralight.javascript.JavascriptObject;
import com.labymedia.ultralight.javascript.JavascriptValue;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public final class HeuristicMethodChooser
implements MethodChooser {
    @Override
    public <T extends Executable> CallData<T> choose(Collection<? extends T> possibilities, JavascriptValue ... javascriptValues) {
        Class[] parameterTypes = new Class[javascriptValues.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = JavascriptConversionUtils.determineType(javascriptValues[i]);
        }
        return this.choose(possibilities, parameterTypes, javascriptValues);
    }

    @Override
    public <T extends Executable> CallData<T> choose(Collection<? extends T> possibilities, Class<?>[] sourceParameterTypes, JavascriptValue[] javascriptValues) {
        int penalty = Integer.MAX_VALUE;
        ArrayList<CallData<Executable>> availableMethods = new ArrayList<CallData<Executable>>(possibilities.size());
        block0: for (Executable executable : possibilities) {
            boolean injectContext = executable.isAnnotationPresent(InjectJavascriptContext.class);
            int paramMod = injectContext ? 1 : 0;
            int currentPenalty = 0;
            CallData.VarArgsType varArgsType = null;
            Parameter[] parameters = executable.getParameters();
            if (parameters.length != sourceParameterTypes.length + paramMod && (!executable.isVarArgs() || sourceParameterTypes.length < parameters.length - (injectContext ? 0 : 1))) continue;
            for (int i = 0; i < parameters.length - paramMod; ++i) {
                Class<?> type = sourceParameterTypes[i];
                if (type == null) continue;
                if (i + paramMod == parameters.length - 1 && executable.isVarArgs()) {
                    if (sourceParameterTypes.length < parameters.length) {
                        varArgsType = CallData.VarArgsType.EMPTY;
                        continue;
                    }
                    if (type.isArray() && sourceParameterTypes.length == parameters.length) {
                        if (parameters[i + paramMod].getType().isAssignableFrom(type)) {
                            varArgsType = CallData.VarArgsType.PASS_THROUGH;
                        } else {
                            if (!parameters[i + paramMod].getType().getComponentType().isAssignableFrom(type)) continue block0;
                            varArgsType = CallData.VarArgsType.COMPACT;
                        }
                        currentPenalty += 1000;
                        continue;
                    }
                    varArgsType = CallData.VarArgsType.COMPACT;
                    for (int x = i; x < sourceParameterTypes.length; ++x) {
                        int argPenalty = this.calculatePenalty(parameters[i + paramMod].getType().getComponentType(), sourceParameterTypes[x], javascriptValues[x]);
                        if (argPenalty < 0) continue block0;
                        currentPenalty += argPenalty;
                    }
                    currentPenalty += 1000;
                    continue;
                }
                int argPenalty = this.calculatePenalty(parameters[i + paramMod].getType(), sourceParameterTypes[i], javascriptValues[i]);
                if (argPenalty < 0) continue block0;
                currentPenalty += argPenalty;
            }
            if (currentPenalty < penalty) {
                availableMethods.clear();
            }
            availableMethods.add(new CallData<Executable>(executable, varArgsType));
        }
        if (availableMethods.size() > 1) {
            throw new IllegalStateException(this.formatErrorMessage("Ambiguous argument types, could not determine methods", possibilities, sourceParameterTypes));
        }
        if (availableMethods.isEmpty()) {
            throw new IllegalStateException(this.formatErrorMessage("No matching method found", possibilities, sourceParameterTypes));
        }
        return (CallData)availableMethods.iterator().next();
    }

    private <T extends Executable> String formatErrorMessage(String header, Collection<T> searched, Class<?>[] types) {
        StringBuilder message = new StringBuilder(header);
        message.append('\n');
        message.append("Arguments: [").append(this.formatClasses(types)).append("]\n");
        message.append("Tried ").append(searched.size()).append(" methods:\n");
        Iterator<T> it = searched.iterator();
        while (it.hasNext()) {
            Executable t = (Executable)it.next();
            message.append("- ").append(Modifier.toString(t.getModifiers())).append(" ").append(t.getDeclaringClass().getName()).append('#').append(t.getName()).append('(').append(this.formatClasses(t.getParameterTypes())).append(")").append(it.hasNext() ? "\n" : "");
        }
        return message.toString();
    }

    private String formatClasses(Class<?>[] classes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < classes.length; ++i) {
            Class<?> type = classes[i];
            builder.append(type.getName());
            if (i + 1 == classes.length) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private int calculatePenalty(Class<?> target, Class<?> source, JavascriptValue value) {
        if (target == Object.class) {
            return 100;
        }
        if (target == JavascriptValue.class) {
            return 0;
        }
        if (target == JavascriptObject.class) {
            return value.isObject() ? 0 : -1;
        }
        if (this.isZeroCostConversion(target, source)) {
            return 0;
        }
        if (target == source) {
            return 0;
        }
        if (source == JavascriptObject.class && target.isAnnotationPresent(FunctionalInterface.class) && value.toObject().isFunction()) {
            return 0;
        }
        if (!target.isAssignableFrom(source)) {
            return -1;
        }
        HashMap dist = new HashMap();
        LinkedList<ClassWithPriority> queue = new LinkedList<ClassWithPriority>();
        queue.add(new ClassWithPriority(source, 0));
        while (!queue.isEmpty()) {
            ClassWithPriority cwp = (ClassWithPriority)queue.remove();
            ArrayList<ClassWithPriority> next = new ArrayList<ClassWithPriority>();
            if (cwp.clazz.getSuperclass() != null && target.isAssignableFrom(cwp.clazz.getSuperclass())) {
                next.add(new ClassWithPriority(cwp.clazz.getSuperclass(), cwp.priority + 1));
            }
            Arrays.stream(cwp.clazz.getInterfaces()).filter(target::isAssignableFrom).map(clazz -> new ClassWithPriority((Class<?>)clazz, cwp.priority + 1)).forEach(next::add);
            next.forEach(e -> {
                if (e.priority < dist.getOrDefault(e.clazz, Integer.MAX_VALUE)) {
                    dist.put(e.clazz, e.priority);
                    queue.add((ClassWithPriority)e);
                }
            });
        }
        return (Integer)dist.get(target);
    }

    private boolean isZeroCostConversion(Class<?> target, Class<?> source) {
        if (source == Number.class && (target == Byte.TYPE || target == Short.TYPE || target == Integer.TYPE || target == Long.TYPE || target == Float.TYPE || target == Double.TYPE)) {
            return true;
        }
        if (source == Boolean.class && target == Boolean.TYPE) {
            return true;
        }
        return source == Character.class && target == Character.TYPE;
    }

    private static class ClassWithPriority {
        Class<?> clazz;
        int priority;

        public ClassWithPriority(Class<?> clazz, int priority) {
            this.clazz = clazz;
            this.priority = priority;
        }
    }
}

